/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour;

import com.maltego.guided.tour.GuidedTourPreferences;
import com.maltego.guided.tour.TourStep;
import com.paterva.maltego.util.ui.TranslucentGlassPane;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.lookup.Lookups;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GuidedTour {
    private final List<TourStep.Presenter> stepPresenters = new ArrayList<TourStep.Presenter>();
    private final TourStep.Presenter closePresenter;
    private int currentStep = 0;
    private TourStep.Presenter visiblePresenter;
    private final KeyEventDispatcher tourKeyEventDispatcher = e -> {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.redispatchEvent(this.visiblePresenter.getKeyEventTarget(), e);
        return true;
    };
    private final TourStep guidedTourStep = new GuidedTourStep();
    private final Set<TopComponent> openedTCs = new HashSet<TopComponent>();

    public GuidedTour() {
        this.stepPresenters.add((TourStep.Presenter)Lookups.forPath((String)"GuidedTour/Start").lookup(TourStep.Presenter.class));
        this.stepPresenters.addAll(Lookups.forPath((String)"GuidedTour/Step").lookupAll(TourStep.Presenter.class));
        this.closePresenter = (TourStep.Presenter)Lookups.forPath((String)"GuidedTour/Close").lookup(TourStep.Presenter.class);
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public int totalStepCount() {
        return this.stepPresenters.size();
    }

    public void start() {
        this.currentStep = 0;
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        TopComponent[] topComponents = editorMode.getTopComponents();
        this.openedTCs.addAll(Arrays.asList(topComponents));
        this.showCurrentStep();
    }

    private void showCurrentStep() {
        TourStep.Presenter presenter = this.stepPresenters.get(this.currentStep);
        TranslucentGlassPane.GlassPaneCustomizer glassPaneCustomizer = new TranslucentGlassPane.GlassPaneCustomizer();
        glassPaneCustomizer.addCustomPainter(presenter.getPainter());
        glassPaneCustomizer.addFocusArea(presenter.getFocusArea());
        WindowUtil.showTranslucentGlassPane((TranslucentGlassPane.GlassPaneCustomizer)glassPaneCustomizer);
        presenter.show(this.guidedTourStep);
        this.visiblePresenter = presenter;
    }

    private void end() {
        TourStep.Presenter currentStepPresenter = this.stepPresenters.get(this.currentStep);
        currentStepPresenter.destroy();
        GuidedTourStep closeStep = new GuidedTourStep(){

            @Override
            public void next() {
                GuidedTour.this.closePresenter.destroy();
                GuidedTour.this.showCurrentStep();
            }

            @Override
            public void closeTour() {
                TopComponent[] topComponents;
                Mode editorMode = WindowManager.getDefault().findMode("editor");
                for (TopComponent tc : topComponents = editorMode.getTopComponents()) {
                    if (GuidedTour.this.openedTCs.contains(tc)) continue;
                    tc.close();
                    break;
                }
                GuidedTour.this.openedTCs.clear();
                WindowUtil.hideTranslucentGlassPane();
                GuidedTour.this.closePresenter.destroy();
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.removeKeyEventDispatcher(GuidedTour.this.tourKeyEventDispatcher);
            }
        };
        TranslucentGlassPane.GlassPaneCustomizer glassPaneCustomizer = new TranslucentGlassPane.GlassPaneCustomizer();
        glassPaneCustomizer.addCustomPainter(currentStepPresenter.getPainter());
        glassPaneCustomizer.addFocusArea(currentStepPresenter.getFocusArea());
        WindowUtil.showTranslucentGlassPane((TranslucentGlassPane.GlassPaneCustomizer)glassPaneCustomizer);
        this.closePresenter.show(closeStep);
        this.visiblePresenter = this.closePresenter;
    }

    private class GuidedTourStep
    implements TourStep {
        private GuidedTourStep() {
        }

        @Override
        public int stepId() {
            return GuidedTour.this.currentStep;
        }

        @Override
        public int totalStepCount() {
            return GuidedTour.this.stepPresenters.size() - 1;
        }

        @Override
        public void next() {
            KeyboardFocusManager kfm;
            if (GuidedTour.this.currentStep == 0) {
                kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.addKeyEventDispatcher(GuidedTour.this.tourKeyEventDispatcher);
            }
            WindowUtil.showTranslucentGlassPane();
            ((TourStep.Presenter)GuidedTour.this.stepPresenters.get(GuidedTour.this.currentStep)).destroy();
            GuidedTour.this.currentStep++;
            if (GuidedTour.this.currentStep < GuidedTour.this.stepPresenters.size()) {
                GuidedTour.this.showCurrentStep();
            } else {
                WindowUtil.hideTranslucentGlassPane();
                kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.removeKeyEventDispatcher(GuidedTour.this.tourKeyEventDispatcher);
                GuidedTourPreferences.getInstance().setRemindLater(false);
            }
        }

        @Override
        public void closeTour() {
            GuidedTour.this.end();
        }

        @Override
        public String learnMoreLink() {
            return ((TourStep.Presenter)GuidedTour.this.stepPresenters.get(GuidedTour.this.currentStep)).learnMoreLink();
        }
    }
}

