/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.ui.PortInfo;
import com.paterva.maltego.collab.ui.PortType;
import com.paterva.maltego.collab.ui.PreviousSessionInfo;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.components.HeadingTextAndIcon;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import com.paterva.maltego.util.ui.image.RotatingImage;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SessionInfoForm
extends JPanel {
    static final String OTHER_SERVER_DNS_NAME = "OTHER_SERVER_DNS_NAME";
    static final String PRIVATE_PATERVA_SERVER_DNS_NAME = "PRIVATE_PATERVA_SERVER_DNS_NAME";
    static final String SESSION_NAME = "SESSION_NAME";
    static final String USER_ALIAS = "USER_ALIAS";
    private final Map<String, ItemAndColor> _labelColors = new HashMap<String, ItemAndColor>();
    private final PreviousSessionInfo _oldInfo = PreviousSessionInfo.instance();
    private final RotatingImage _rotatingImage;
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color foregroundColor = LAF.getColor("collaboration-connection-banner-foreground");
    private final Color borderColour = LAF.getColor("collaboration-connection-banner-border");
    private final Color bg = LAF.getColor("3-main-dark-color");
    private final Color _labelErrorColor = LAF.getColor("7-red");
    private JTextPane _256NotPresentTextPane;
    private JComboBox _aliasComboBox;
    private JCheckBox _debugCheckBox;
    private JLabel _defaultServerLabel;
    private JRadioButton _defaultServerRadioButton;
    private JLabel _defaultServerRadioButtonLabel;
    private JLabel _detectPortLabelInfo;
    private JRadioButton _detectPortRadioButton;
    private JRadioButton _encryptionRadioButton128;
    private JRadioButton _encryptionRadioButton256;
    private JButton _generateButton;
    private JSpinner _httpBindPortSpinner;
    private JRadioButton _httpBindRadioButton;
    private JSpinner _httpsBindPortSpinner;
    private JRadioButton _httpsBindRadioButton;
    private JComboBox _keyComboBox;
    private JLabel _normalPortLabelInfo;
    private JRadioButton _normalPortRadioButton;
    private JSpinner _normalPortSpinner;
    private JComboBox _otherServerComboBox;
    private JLabel _otherServerComboBoxLabel;
    private JLabel _otherServerLabel;
    private JRadioButton _otherServerRadioButton;
    private JLabel _otherServerRadioButtonLabel;
    private JPasswordField _passwordField;
    private JLabel _passwordLabel;
    private JLabel _portLabel;
    private JComboBox _privatePatervaServerComboBox;
    private JLabel _privatePatervaServerComboBoxLabel;
    private JLabel _privatePatervaServerLabel;
    private JRadioButton _privatePatervaServerRadioButton;
    private JLabel _privatePatervaServerRadioButtonLabel;
    private JCheckBox _saveKeyCheckBox;
    private JCheckBox _savePasswordCheckBox;
    private ButtonGroup _serverButtonGroup;
    private JComboBox _sessionComboBox;
    private JLabel _sessionNameLabel;
    private JRadioButton _sslPortRadioButton;
    private JSpinner _sslPortSpinner;
    private JLabel _userAliasLabel;
    private JComboBox _userComboBox;
    private JLabel _userLabel;
    private ButtonGroup encryptionButtonGroup;
    private HeadingTextAndIcon headingTextAndIcon1;
    private JPanel jPanel8;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea2;
    private JPanel placeholder;
    private ButtonGroup portButtonGroup;
    private JTextArea sessionNameInfojTextArea;

    public SessionInfoForm() {
        this.initComponents();
        Image image = ImageUtilities.loadImage((String)"com/paterva/maltego/collab/resources/ConnectRotating48.png");
        BufferedImage resizedCanvas = new BufferedImage(60, 60, 2);
        Graphics2D imgGraphics = resizedCanvas.createGraphics();
        imgGraphics.drawImage(image, 8, 7, null);
        imgGraphics.dispose();
        this._rotatingImage = new RotatingImage((Image)resizedCanvas, 20, 5);
        this.headingTextAndIcon1.addIcon((Object)this._rotatingImage);
        this.headingTextAndIcon1.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.jTextArea1.text"));
        this.populate(this._sessionComboBox, this._oldInfo.getSessionNames());
        this.populate(this._keyComboBox, this._oldInfo.getSecurityKeys());
        this.populate(this._aliasComboBox, this._oldInfo.getAliases());
        this.populate(this._privatePatervaServerComboBox, this._oldInfo.getPrivatePatervaServerDnsNames());
        this.populate(this._otherServerComboBox, this._oldInfo.getServerDnsNames());
        this.populate(this._userComboBox, this._oldInfo.getUsers());
        this._savePasswordCheckBox.setSelected(this._oldInfo.isSavePassword());
        this._sessionComboBox.addActionListener(new SessionChangedListener());
        ServerTypeListener serverTypeListener = new ServerTypeListener();
        this._defaultServerRadioButton.addActionListener(serverTypeListener);
        this._privatePatervaServerRadioButton.addActionListener(serverTypeListener);
        this._otherServerRadioButton.addActionListener(serverTypeListener);
        this._privatePatervaServerComboBox.addActionListener(new PrivatePatervaServerChangedListener());
        this._otherServerComboBox.addActionListener(new ServerChangedListener());
        this._userComboBox.addActionListener(new UserChangedListener());
        this._sessionComboBox.setSelectedItem(this._oldInfo.getSessionNames().get(0));
        this._debugCheckBox.setSelected(this._oldInfo.isDebug());
        this._debugCheckBox.setVisible(Version.getCurrent().isDevBuild());
        this._saveKeyCheckBox.setSelected(this._oldInfo.isSaveKey());
        this._encryptionRadioButton256.setSelected(this._oldInfo.use256Encryption());
        this._encryptionRadioButton128.setSelected(!this._oldInfo.use256Encryption());
        this.check256Support();
        this.checkVersion();
        this._otherServerRadioButton.addChangeListener((ChangeListener)this._changeSupport);
        this._privatePatervaServerRadioButton.addChangeListener((ChangeListener)this._changeSupport);
        ((JTextComponent)this._otherServerComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        ((JTextComponent)this._privatePatervaServerComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        ((JTextComponent)this._sessionComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        ((JTextComponent)this._aliasComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        this._labelColors.put(OTHER_SERVER_DNS_NAME, new ItemAndColor(this._otherServerComboBoxLabel, this._labelErrorColor));
        this._labelColors.put(PRIVATE_PATERVA_SERVER_DNS_NAME, new ItemAndColor(this._privatePatervaServerComboBoxLabel, this._labelErrorColor));
        this._labelColors.put(SESSION_NAME, new ItemAndColor(this._sessionNameLabel, this._labelErrorColor));
        this._labelColors.put(USER_ALIAS, new ItemAndColor(this._userAliasLabel, this._labelErrorColor));
    }

    public void addChangeListener(ChangeListener l) {
        this._changeSupport.addChangeListener(l);
    }

    String getSession() {
        String session = this.getSelected(this._sessionComboBox);
        if (session != null) {
            session = session.trim().replaceAll("\\s", "_");
        }
        return session;
    }

    private void check256Support() {
        this._256NotPresentTextPane.setVisible(false);
        try {
            int maxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (maxKeyLength < 256) {
                this._encryptionRadioButton256.setEnabled(false);
                this._encryptionRadioButton128.setSelected(true);
                this._256NotPresentTextPane.setVisible(true);
                this._256NotPresentTextPane.setEnabled(true);
                this._256NotPresentTextPane.setEditable(false);
                this._256NotPresentTextPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        URL url;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !FileUtilities.isRemoteFileURL((URL)(url = e.getURL()))) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        }
                    }
                });
            }
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.print("AES Algorithm not found on system!");
        }
    }

    private String getKey() {
        return this.getSelected(this._keyComboBox);
    }

    String getAlias() {
        return this.getSelected(this._aliasComboBox);
    }

    public boolean isUseOtherServer() {
        return this._otherServerRadioButton.isSelected();
    }

    public boolean isUseDefaultServer() {
        return this._defaultServerRadioButton.isSelected();
    }

    public boolean isUsePrivatePatervaServer() {
        return this._privatePatervaServerRadioButton.isSelected();
    }

    public String getPrivatePatervaServerDnsName() {
        return this.getSelected(this._privatePatervaServerComboBox);
    }

    void setErrorState(boolean isInError) {
    }

    public String getServerDnsName() {
        return this.getSelected(this._otherServerComboBox);
    }

    public PortInfo getPortInfo() {
        PortInfo portInfo = new PortInfo();
        if (this._sslPortRadioButton.isSelected()) {
            portInfo.setSelectedType(PortType.SSL);
        } else if (this._httpBindRadioButton.isSelected()) {
            portInfo.setSelectedType(PortType.HTTP);
        } else if (this._httpsBindRadioButton.isSelected()) {
            portInfo.setSelectedType(PortType.HTTPS);
        } else if (this._detectPortRadioButton.isSelected()) {
            portInfo.setSelectedType(PortType.AUTO);
        } else {
            portInfo.setSelectedType(PortType.NORMAL);
        }
        portInfo.setPort(PortType.NORMAL, (Integer)this._normalPortSpinner.getValue());
        portInfo.setPort(PortType.SSL, (Integer)this._sslPortSpinner.getValue());
        portInfo.setPort(PortType.HTTP, (Integer)this._httpBindPortSpinner.getValue());
        portInfo.setPort(PortType.HTTPS, (Integer)this._httpsBindPortSpinner.getValue());
        return portInfo;
    }

    public boolean isAutoRegister() {
        return this.isUseDefaultServer() || this.isUsePrivatePatervaServer();
    }

    public String getUsername() {
        return this.getSelected(this._userComboBox);
    }

    public boolean isSavePassword() {
        return this._savePasswordCheckBox.isSelected();
    }

    public String getPassword() {
        return String.valueOf(this._passwordField.getPassword());
    }

    public boolean isDebugSession() {
        return this._debugCheckBox.isSelected();
    }

    public boolean isSaveKey() {
        return this._saveKeyCheckBox.isSelected();
    }

    public void setIsWorking(boolean working) {
        if (working) {
            this._rotatingImage.start();
        } else {
            this._rotatingImage.pause();
        }
    }

    public boolean isUse256Encryption() {
        return this._encryptionRadioButton256.isSelected();
    }

    public CollaborationSessionInfo getChatRoomInfo() {
        boolean useDefaultServer = this.isUseDefaultServer();
        boolean usePrivatePatervaServer = this.isUsePrivatePatervaServer();
        CollaborationSessionInfo info = new CollaborationSessionInfo();
        info.setRoomName(this.getSession());
        info.setSecurityKey(this.getKey());
        info.setAlias(this.getAlias());
        info.setUseDefaultServer(useDefaultServer);
        info.setUsePrivatePatervaServer(usePrivatePatervaServer);
        String server = usePrivatePatervaServer ? this.getPrivatePatervaServerDnsName() : this.getServerDnsName();
        info.setService(server);
        info.setServer(server);
        info.setPortInfo(this.getPortInfo());
        info.setAutoRegister(this.isAutoRegister());
        info.setUsername(this.getUsername().toLowerCase());
        info.setPassword(this.getPassword());
        info.setDebugSession(this.isDebugSession());
        info.use256Encryption(this.isUse256Encryption());
        return info;
    }

    public void storeInfo() {
        String session = this.getSession();
        String key = this.getKey();
        String alias = this.getAlias();
        boolean useDefaultServer = this.isUseDefaultServer();
        boolean usePrivatePatervaServer = this.isUsePrivatePatervaServer();
        String privatePatervaServerDnsName = this.getPrivatePatervaServerDnsName();
        String server = this.getServerDnsName();
        PortInfo portInfo = this.getPortInfo();
        boolean autoRegister = this.isAutoRegister();
        String user = this.getUsername();
        boolean savePassword = this.isSavePassword();
        String password = this.getPassword();
        boolean isDebug = this.isDebugSession();
        boolean encryption256 = this.isUse256Encryption();
        boolean isSaveKey = this.isSaveKey();
        this._oldInfo.add(session, key, alias, useDefaultServer, usePrivatePatervaServer, privatePatervaServerDnsName, server, portInfo, autoRegister, user, password, savePassword, isDebug, encryption256, isSaveKey);
    }

    private String getSelected(JComboBox comboBox) {
        JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
        String text = editor.getText();
        if (text == null) {
            text = (String)comboBox.getSelectedItem();
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    private void onUserChanged() {
        String user = this.getUsername();
        if (this._oldInfo.getUsers().contains(user)) {
            String server = this.getServerDnsName();
            String password = this._oldInfo.getPassword(server, user);
            this._passwordField.setText(password);
        }
    }

    private void onPrivatePatervaServerChanged() {
        String server = this.getPrivatePatervaServerDnsName();
    }

    private void onServerChanged() {
        String server = this.getServerDnsName();
        PortInfo portInfo = this._oldInfo.getPortInfo(server);
        PortType type = portInfo.getSelectedType();
        switch (type) {
            case NORMAL: {
                this._normalPortRadioButton.setSelected(true);
                break;
            }
            case SSL: {
                this._sslPortRadioButton.setSelected(true);
                break;
            }
            case HTTP: {
                this._httpBindRadioButton.setSelected(true);
                break;
            }
            case HTTPS: {
                this._httpsBindRadioButton.setSelected(true);
                break;
            }
            case AUTO: {
                this._detectPortRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + (Object)((Object)type));
            }
        }
        this._normalPortSpinner.setValue(portInfo.getPort(PortType.NORMAL));
        this._sslPortSpinner.setValue(portInfo.getPort(PortType.SSL));
        this._httpBindPortSpinner.setValue(portInfo.getPort(PortType.HTTP));
        this._httpsBindPortSpinner.setValue(portInfo.getPort(PortType.HTTPS));
        this._userComboBox.setSelectedItem(this._oldInfo.getUser(server));
        this.updateCredentialsEnabled();
    }

    private void onSessionChanged() {
        String session = this.getSession();
        if (this._oldInfo.getSessionNames().contains(session)) {
            this._keyComboBox.setSelectedItem(this._oldInfo.getSecurityKey(session));
            this._aliasComboBox.setSelectedItem(this._oldInfo.getAlias(session));
            if (this._oldInfo.isUseDefaultServer(session)) {
                this._defaultServerRadioButton.doClick();
            } else if (this._oldInfo.isUsePrivatePatervaServer(session)) {
                this._privatePatervaServerRadioButton.doClick();
            } else {
                this._otherServerRadioButton.doClick();
            }
            this._privatePatervaServerComboBox.setSelectedItem(this._oldInfo.getPrivatePatervaServerDnsName(session));
            this._otherServerComboBox.setSelectedItem(this._oldInfo.getServerDnsName(session));
        }
    }

    private void onServerTypeChanged() {
        boolean defaultServer = this._defaultServerRadioButton.isSelected() || !this._privatePatervaServerRadioButton.isEnabled() && !this._otherServerRadioButton.isEnabled();
        this._defaultServerLabel.setEnabled(defaultServer);
        boolean privatePatervaServer = this._privatePatervaServerRadioButton.isSelected();
        this._privatePatervaServerLabel.setEnabled(privatePatervaServer);
        this._privatePatervaServerComboBoxLabel.setEnabled(privatePatervaServer);
        this._privatePatervaServerComboBox.setEnabled(privatePatervaServer);
        boolean otherServer = this._otherServerRadioButton.isSelected();
        this._otherServerLabel.setEnabled(otherServer);
        this._otherServerComboBoxLabel.setEnabled(otherServer);
        this._otherServerComboBox.setEnabled(otherServer);
        this._portLabel.setEnabled(otherServer);
        this._detectPortRadioButton.setEnabled(otherServer);
        this._detectPortLabelInfo.setEnabled(otherServer);
        this._normalPortRadioButton.setEnabled(otherServer);
        this._normalPortSpinner.setEnabled(otherServer);
        this._normalPortLabelInfo.setEnabled(otherServer);
        this._sslPortRadioButton.setEnabled(otherServer);
        this._sslPortSpinner.setEnabled(otherServer);
        this._httpBindRadioButton.setEnabled(otherServer);
        this._httpBindPortSpinner.setEnabled(otherServer);
        this._httpsBindRadioButton.setEnabled(otherServer);
        this._httpsBindPortSpinner.setEnabled(otherServer);
        this.updateCredentialsEnabled();
    }

    private void updateCredentialsEnabled() {
        boolean autoRegister = this.isAutoRegister();
        boolean otherServer = this._otherServerRadioButton.isSelected();
        boolean enable = otherServer && !autoRegister;
        this._userLabel.setEnabled(enable);
        this._userComboBox.setEnabled(enable);
        this._passwordLabel.setEnabled(enable);
        this._passwordField.setEnabled(enable);
        this._savePasswordCheckBox.setEnabled(enable);
        this.checkVersion();
    }

    private void checkVersion() {
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        if (!A.J((com.paterva.maltego.licensing.mode.A)licenseMode)) {
            this._defaultServerRadioButton.setSelected(true);
            this._privatePatervaServerRadioButton.setEnabled(false);
            this._privatePatervaServerRadioButtonLabel.setEnabled(false);
            String upgradeSuffix = " - Upgrade Maltego to activate option";
            String privateText = this._privatePatervaServerRadioButtonLabel.getText();
            if (!privateText.endsWith(upgradeSuffix)) {
                this._privatePatervaServerRadioButtonLabel.setText(privateText + upgradeSuffix);
            }
            this._privatePatervaServerLabel.setEnabled(false);
            this._privatePatervaServerComboBoxLabel.setEnabled(false);
            this._privatePatervaServerComboBox.setEnabled(false);
            this._privatePatervaServerComboBox.setSelectedItem("");
            this._otherServerRadioButton.setEnabled(false);
            this._otherServerRadioButtonLabel.setEnabled(false);
            String otherText = this._otherServerRadioButtonLabel.getText();
            if (!otherText.endsWith(upgradeSuffix)) {
                this._otherServerRadioButtonLabel.setText(otherText + upgradeSuffix);
            }
            this._otherServerLabel.setEnabled(false);
            this._otherServerComboBoxLabel.setEnabled(false);
            this._otherServerComboBox.setEnabled(false);
            this._otherServerComboBox.setSelectedItem("");
            this._portLabel.setEnabled(false);
            this._detectPortRadioButton.setEnabled(false);
            this._detectPortLabelInfo.setEnabled(false);
            this._normalPortRadioButton.setEnabled(false);
            this._normalPortSpinner.setEnabled(false);
            this._normalPortLabelInfo.setEnabled(false);
            this._sslPortRadioButton.setEnabled(false);
            this._sslPortSpinner.setEnabled(false);
            this._httpBindRadioButton.setEnabled(false);
            this._httpBindPortSpinner.setEnabled(false);
            this._httpsBindRadioButton.setEnabled(false);
            this._httpsBindPortSpinner.setEnabled(false);
            this._userLabel.setEnabled(false);
            this._userComboBox.setEnabled(false);
            this._userComboBox.setSelectedItem("");
            this._passwordLabel.setEnabled(false);
            this._passwordField.setEnabled(false);
            this._passwordField.setText("");
            this._savePasswordCheckBox.setEnabled(false);
            this._savePasswordCheckBox.setSelected(false);
        }
    }

    private void initComponents() {
        this._serverButtonGroup = new ButtonGroup();
        this.encryptionButtonGroup = new ButtonGroup();
        this.portButtonGroup = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        JTextArea securityKeyInfoTextPane = new JTextArea();
        this._generateButton = new JButton();
        JTextArea userAliasInfoTextPane = new JTextArea();
        this._debugCheckBox = new JCheckBox();
        this._keyComboBox = new JComboBox();
        this._aliasComboBox = new JComboBox();
        this._sessionComboBox = new JComboBox();
        this.sessionNameInfojTextArea = new JTextArea();
        this._saveKeyCheckBox = new JCheckBox();
        this._userAliasLabel = new LabelWithBackground();
        LabelWithBackground jLabel2 = new LabelWithBackground();
        this._sessionNameLabel = new LabelWithBackground();
        JPanel jPanel4 = new JPanel();
        this.placeholder = new JPanel();
        this._privatePatervaServerRadioButton = new JRadioButton();
        this._userLabel = new LabelWithBackground();
        this._otherServerComboBoxLabel = new LabelWithBackground();
        this._otherServerRadioButton = new JRadioButton();
        this._savePasswordCheckBox = new JCheckBox();
        this._otherServerComboBox = new JComboBox();
        this._userComboBox = new JComboBox();
        this._portLabel = new LabelWithBackground();
        this._defaultServerRadioButton = new JRadioButton();
        this._normalPortSpinner = new JSpinner();
        this._sslPortRadioButton = new JRadioButton();
        this._httpBindRadioButton = new JRadioButton();
        this._httpsBindRadioButton = new JRadioButton();
        this._normalPortRadioButton = new JRadioButton();
        this._httpBindPortSpinner = new JSpinner();
        this._sslPortSpinner = new JSpinner();
        this._httpsBindPortSpinner = new JSpinner();
        this._normalPortLabelInfo = new JLabel();
        this._detectPortRadioButton = new JRadioButton();
        this._detectPortLabelInfo = new JLabel();
        this._passwordLabel = new LabelWithBackground();
        this._defaultServerLabel = new JLabel();
        this._privatePatervaServerLabel = new JLabel();
        this._privatePatervaServerComboBox = new JComboBox();
        this._privatePatervaServerComboBoxLabel = new LabelWithBackground();
        this._passwordField = new JPasswordField();
        this._otherServerLabel = new JLabel();
        this._defaultServerRadioButtonLabel = new JLabel();
        this._privatePatervaServerRadioButtonLabel = new JLabel();
        this._otherServerRadioButtonLabel = new JLabel();
        JPanel jPanel6 = new JPanel();
        this.jTextArea2 = new JTextArea();
        this._256NotPresentTextPane = new JTextPane();
        this._encryptionRadioButton256 = new JRadioButton();
        this._encryptionRadioButton128 = new JRadioButton();
        this.jPanel8 = new JPanel();
        this.headingTextAndIcon1 = new HeadingTextAndIcon();
        this.setBackground(this.bg);
        this.setMinimumSize(new Dimension(636, 480));
        this.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 6, 6, 6));
        jPanel3.setLayout(new GridBagLayout());
        securityKeyInfoTextPane.setEditable(false);
        securityKeyInfoTextPane.setColumns(20);
        securityKeyInfoTextPane.setFont(new JLabel().getFont());
        securityKeyInfoTextPane.setForeground(this.foregroundColor);
        securityKeyInfoTextPane.setLineWrap(true);
        securityKeyInfoTextPane.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.securityKeyInfoTextPane.text"));
        securityKeyInfoTextPane.setWrapStyleWord(true);
        securityKeyInfoTextPane.setBorder(null);
        securityKeyInfoTextPane.setFocusable(false);
        securityKeyInfoTextPane.setOpaque(false);
        securityKeyInfoTextPane.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 8, 20, 6);
        jPanel3.add((Component)securityKeyInfoTextPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._generateButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._generateButton.text"));
        this._generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SessionInfoForm.this._generateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel3.add((Component)this._generateButton, gridBagConstraints);
        userAliasInfoTextPane.setEditable(false);
        userAliasInfoTextPane.setColumns(20);
        userAliasInfoTextPane.setFont(new JLabel().getFont());
        userAliasInfoTextPane.setForeground(this.foregroundColor);
        userAliasInfoTextPane.setLineWrap(true);
        userAliasInfoTextPane.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.userAliasInfoTextPane.text"));
        userAliasInfoTextPane.setWrapStyleWord(true);
        userAliasInfoTextPane.setBorder(null);
        userAliasInfoTextPane.setFocusable(false);
        userAliasInfoTextPane.setOpaque(false);
        userAliasInfoTextPane.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 8, 6, 6);
        jPanel3.add((Component)userAliasInfoTextPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._debugCheckBox, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._debugCheckBox.text"));
        this._debugCheckBox.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel3.add((Component)this._debugCheckBox, gridBagConstraints);
        this._keyComboBox.setBackground(new Color(255, 102, 102));
        this._keyComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._keyComboBox, gridBagConstraints);
        this._aliasComboBox.setBackground(new Color(255, 51, 51));
        this._aliasComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._aliasComboBox, gridBagConstraints);
        this._sessionComboBox.setBackground(new Color(255, 51, 51));
        this._sessionComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this._sessionComboBox, gridBagConstraints);
        this.sessionNameInfojTextArea.setEditable(false);
        this.sessionNameInfojTextArea.setColumns(20);
        this.sessionNameInfojTextArea.setFont(new JLabel().getFont());
        this.sessionNameInfojTextArea.setForeground(this.foregroundColor);
        this.sessionNameInfojTextArea.setLineWrap(true);
        this.sessionNameInfojTextArea.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.sessionNameInfojTextArea.text"));
        this.sessionNameInfojTextArea.setWrapStyleWord(true);
        this.sessionNameInfojTextArea.setBorder(null);
        this.sessionNameInfojTextArea.setFocusable(false);
        this.sessionNameInfojTextArea.setOpaque(false);
        this.sessionNameInfojTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 8, 20, 6);
        jPanel3.add((Component)this.sessionNameInfojTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._saveKeyCheckBox, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._saveKeyCheckBox.text"));
        this._saveKeyCheckBox.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel3.add((Component)this._saveKeyCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._userAliasLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._userAliasLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this._userAliasLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        this._sessionNameLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this._sessionNameLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._sessionNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this._sessionNameLabel, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.jPanel3.TabConstraints.tabTitle"), jPanel3);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 6, 6, 6));
        jPanel4.setName("");
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add((Component)this.placeholder, gridBagConstraints);
        this._serverButtonGroup.add(this._privatePatervaServerRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._privatePatervaServerRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._userLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._userLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._userLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._otherServerComboBoxLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._otherServerComboBoxLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._otherServerComboBoxLabel, gridBagConstraints);
        this._serverButtonGroup.add(this._otherServerRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._otherServerRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._savePasswordCheckBox, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._savePasswordCheckBox.text"));
        this._savePasswordCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel4.add((Component)this._savePasswordCheckBox, gridBagConstraints);
        this._otherServerComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._otherServerComboBox, gridBagConstraints);
        this._userComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._userComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._portLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._portLabel.text"));
        this._portLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._portLabel, gridBagConstraints);
        this._serverButtonGroup.add(this._defaultServerRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._defaultServerRadioButton, gridBagConstraints);
        this._normalPortSpinner.setEditor(new JSpinner.NumberEditor(this._normalPortSpinner, "####"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 0);
        jPanel4.add((Component)this._normalPortSpinner, gridBagConstraints);
        this.portButtonGroup.add(this._sslPortRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._sslPortRadioButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._sslPortRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._sslPortRadioButton, gridBagConstraints);
        this.portButtonGroup.add(this._httpBindRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._httpBindRadioButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._httpBindRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._httpBindRadioButton, gridBagConstraints);
        this.portButtonGroup.add(this._httpsBindRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._httpsBindRadioButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._httpsBindRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._httpsBindRadioButton, gridBagConstraints);
        this.portButtonGroup.add(this._normalPortRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._normalPortRadioButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._normalPortRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._normalPortRadioButton, gridBagConstraints);
        this._httpBindPortSpinner.setModel(new SpinnerNumberModel());
        this._httpBindPortSpinner.setEditor(new JSpinner.NumberEditor(this._httpBindPortSpinner, "####"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 0);
        jPanel4.add((Component)this._httpBindPortSpinner, gridBagConstraints);
        this._sslPortSpinner.setEditor(new JSpinner.NumberEditor(this._sslPortSpinner, "####"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 0);
        jPanel4.add((Component)this._sslPortSpinner, gridBagConstraints);
        this._httpsBindPortSpinner.setEditor(new JSpinner.NumberEditor(this._httpsBindPortSpinner, "####"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 0);
        jPanel4.add((Component)this._httpsBindPortSpinner, gridBagConstraints);
        this._normalPortLabelInfo.setForeground(this.foregroundColor);
        Mnemonics.setLocalizedText((JLabel)this._normalPortLabelInfo, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._normalPortLabelInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        jPanel4.add((Component)this._normalPortLabelInfo, gridBagConstraints);
        this.portButtonGroup.add(this._detectPortRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this._detectPortRadioButton, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._detectPortRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._detectPortRadioButton, gridBagConstraints);
        this._detectPortLabelInfo.setForeground(this.foregroundColor);
        Mnemonics.setLocalizedText((JLabel)this._detectPortLabelInfo, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._detectPortLabelInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this._detectPortLabelInfo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._passwordLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._passwordLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._passwordLabel, gridBagConstraints);
        this._defaultServerLabel.setForeground(this.foregroundColor);
        Mnemonics.setLocalizedText((JLabel)this._defaultServerLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._defaultServerLabel.text"));
        this._defaultServerLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._defaultServerLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        jPanel4.add((Component)this._defaultServerLabel, gridBagConstraints);
        this._privatePatervaServerLabel.setForeground(this.foregroundColor);
        Mnemonics.setLocalizedText((JLabel)this._privatePatervaServerLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._privatePatervaServerLabel.text"));
        this._privatePatervaServerLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._privatePatervaServerLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        jPanel4.add((Component)this._privatePatervaServerLabel, gridBagConstraints);
        this._privatePatervaServerComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._privatePatervaServerComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._privatePatervaServerComboBoxLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._privatePatervaServerComboBoxLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._privatePatervaServerComboBoxLabel, gridBagConstraints);
        this._passwordField.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._passwordField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel4.add((Component)this._passwordField, gridBagConstraints);
        this._otherServerLabel.setForeground(this.foregroundColor);
        Mnemonics.setLocalizedText((JLabel)this._otherServerLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._otherServerLabel.text"));
        this._otherServerLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._otherServerLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        jPanel4.add((Component)this._otherServerLabel, gridBagConstraints);
        this._defaultServerRadioButtonLabel.setFont(new JLabel().getFont().deriveFont(1));
        Mnemonics.setLocalizedText((JLabel)this._defaultServerRadioButtonLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._defaultServerRadioButtonLabel.text"));
        this._defaultServerRadioButtonLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._defaultServerRadioButtonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SessionInfoForm.this._defaultServerRadioButtonLabelMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._defaultServerRadioButtonLabel, gridBagConstraints);
        this._privatePatervaServerRadioButtonLabel.setFont(new JLabel().getFont().deriveFont(1));
        Mnemonics.setLocalizedText((JLabel)this._privatePatervaServerRadioButtonLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._privatePatervaServerRadioButtonLabel.text"));
        this._privatePatervaServerRadioButtonLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._privatePatervaServerRadioButtonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SessionInfoForm.this._privatePatervaServerRadioButtonLabelMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._privatePatervaServerRadioButtonLabel, gridBagConstraints);
        this._otherServerRadioButtonLabel.setFont(new JLabel().getFont().deriveFont(1));
        Mnemonics.setLocalizedText((JLabel)this._otherServerRadioButtonLabel, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._otherServerRadioButtonLabel.text"));
        this._otherServerRadioButtonLabel.setBorder(LabelWithBackground.getBorderCustom());
        this._otherServerRadioButtonLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SessionInfoForm.this._otherServerRadioButtonLabelMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._otherServerRadioButtonLabel, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.TabConstraints.tabTitle"), jPanel4);
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 6, 6, 6));
        jPanel6.setLayout(new GridBagLayout());
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new JLabel().getFont());
        this.jTextArea2.setForeground(this.foregroundColor);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.jTextArea2.text"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setBorder(BorderFactory.createEmptyBorder(0, 3, 12, 3));
        this.jTextArea2.setFocusable(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.jTextArea2, gridBagConstraints);
        this._256NotPresentTextPane.setEditable(false);
        this._256NotPresentTextPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.borderColour), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this._256NotPresentTextPane.setContentType("text/html");
        this._256NotPresentTextPane.setFont(new JLabel().getFont());
        this._256NotPresentTextPane.setText(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._256NotPresentTextPane.text"));
        this._256NotPresentTextPane.setCursor(new Cursor(12));
        this._256NotPresentTextPane.setOpaque(false);
        this._256NotPresentTextPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        jPanel6.add((Component)this._256NotPresentTextPane, gridBagConstraints);
        this.encryptionButtonGroup.add(this._encryptionRadioButton256);
        Mnemonics.setLocalizedText((AbstractButton)this._encryptionRadioButton256, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._encryptionRadioButton256.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel6.add((Component)this._encryptionRadioButton256, gridBagConstraints);
        this.encryptionButtonGroup.add(this._encryptionRadioButton128);
        Mnemonics.setLocalizedText((AbstractButton)this._encryptionRadioButton128, (String)NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm._encryptionRadioButton128.text"));
        this._encryptionRadioButton128.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SessionInfoForm.this._encryptionRadioButton128ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        jPanel6.add((Component)this._encryptionRadioButton128, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add((Component)this.jPanel8, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(SessionInfoForm.class, (String)"SessionInfoForm.jPanel6.TabConstraints.tabTitle"), jPanel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.headingTextAndIcon1, gridBagConstraints);
    }

    private void _generateButtonActionPerformed(ActionEvent evt) {
        this._keyComboBox.setSelectedItem(this._oldInfo.generateKey());
    }

    private void _encryptionRadioButton128ActionPerformed(ActionEvent evt) {
    }

    private void _defaultServerRadioButtonLabelMouseReleased(MouseEvent evt) {
        this._defaultServerRadioButton.setSelected(true);
        this.onServerTypeChanged();
    }

    private void _privatePatervaServerRadioButtonLabelMouseReleased(MouseEvent evt) {
        this._privatePatervaServerRadioButton.setSelected(true);
        this.onServerTypeChanged();
    }

    private void _otherServerRadioButtonLabelMouseReleased(MouseEvent evt) {
        this._otherServerRadioButton.setSelected(true);
        this.onServerTypeChanged();
    }

    private void populate(JComboBox comboBox, List<String> values) {
        comboBox.removeAllItems();
        values = new ArrayList<String>(values);
        Collections.sort(values);
        for (String value : values) {
            if (StringUtilities.isNullOrEmpty((String)value)) continue;
            comboBox.addItem(value);
        }
    }

    void clearAllErrors() {
        for (Map.Entry<String, ItemAndColor> entry : this._labelColors.entrySet()) {
            ItemAndColor value = entry.getValue();
            value.setToNorm();
        }
    }

    void enableErrorState(String item) {
        this._labelColors.get(item).setToError();
    }

    private class ServerTypeListener
    implements ActionListener {
        private ServerTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionInfoForm.this.onServerTypeChanged();
        }
    }

    private class SessionChangedListener
    implements ActionListener {
        private SessionChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionInfoForm.this.onSessionChanged();
        }
    }

    private class ServerChangedListener
    implements ActionListener {
        private ServerChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionInfoForm.this.onServerChanged();
        }
    }

    private class PrivatePatervaServerChangedListener
    implements ActionListener {
        private PrivatePatervaServerChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionInfoForm.this.onPrivatePatervaServerChanged();
        }
    }

    private class UserChangedListener
    implements ActionListener {
        private UserChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionInfoForm.this.onUserChanged();
        }
    }

    private static class ItemAndColor {
        private final Color _normalTextColor;
        private final Color _errorTextColor;
        private final JComponent _component;

        ItemAndColor(JComponent component, Color errorTextColor) {
            this._component = component;
            this._normalTextColor = this._component.getForeground();
            this._errorTextColor = errorTextColor;
        }

        void setToError() {
            this._component.setForeground(this._errorTextColor);
        }

        void setToNorm() {
            this._component.setForeground(this._normalTextColor);
        }
    }
}

