/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Cookie {
    private static final Logger LOG = Logger.getLogger(Cookie.class.getName());
    private final String name;
    private String value;
    private String domain;
    private long maxAge = -1L;
    private String path;
    private String portlist;
    private boolean secure;
    private int version = 1;
    private final long creationTime = System.currentTimeMillis();

    public Cookie(String name, String value) {
        this.name = name = name.trim();
        this.value = value;
        this.secure = false;
        this.portlist = null;
    }

    public static List<Cookie> parse(String header) {
        int version = Cookie.retrieveVersion(header);
        if (Cookie.startsWithIgnoreCase(header, "set-cookie2:")) {
            header = header.substring("set-cookie2:".length());
        } else if (Cookie.startsWithIgnoreCase(header, "set-cookie:")) {
            header = header.substring("set-cookie:".length());
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        if (version == 0) {
            Cookie cookie = Cookie.parseHeader(header);
            cookie.setVersion(0);
            cookies.add(cookie);
        } else {
            for (String cookieString : Cookie.splitCookies(header)) {
                Cookie cookie = Cookie.parseHeader(cookieString);
                cookie.setVersion(1);
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    private static List<String> splitCookies(String header) {
        ArrayList<String> cookies = new ArrayList<String>();
        int quoteCount = 0;
        int q = 0;
        for (int p = 0; p < header.length(); ++p) {
            char c = header.charAt(p);
            if (c == '\"') {
                ++quoteCount;
            }
            if (c != ',' || quoteCount % 2 != 0) continue;
            cookies.add(header.substring(q, p));
            q = p + 1;
        }
        cookies.add(header.substring(q));
        return cookies;
    }

    private static int retrieveVersion(String header) {
        int version = 0;
        if ((header = header.toLowerCase()).indexOf("expires=") != -1) {
            version = 0;
        } else if (header.indexOf("version=") != -1) {
            version = 1;
        } else if (header.indexOf("max-age") != -1) {
            version = 1;
        } else if (Cookie.startsWithIgnoreCase(header, "set-cookie2:")) {
            version = 1;
        }
        return version;
    }

    public boolean hasExpired() {
        if (this.maxAge == 0L) {
            return true;
        }
        if (this.maxAge == -1L) {
            return false;
        }
        long diffSec = (System.currentTimeMillis() - this.creationTime) / 1000L;
        return diffSec > this.maxAge;
    }

    public void setPortlist(String ports) {
        this.portlist = ports;
    }

    public String getPortlist() {
        return this.portlist;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(long expiry) {
        this.maxAge = expiry;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static boolean matches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String s1 = host.substring(0, lengthDiff);
            String s2 = host.substring(lengthDiff);
            return s1.indexOf(46) == -1 && s2.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getVersion() > 0) {
            sb.append(this.getName()).append("=\"").append(this.getValue()).append('\"');
            if (this.getPath() != null) {
                sb.append(";$Path=\"").append(this.getPath()).append('\"');
            }
            if (this.getPortlist() != null) {
                sb.append(";$Port=\"").append(this.getPortlist()).append('\"');
            }
            if (this.getDomain() != null) {
                sb.append(";$Domain=\"").append(this.getDomain()).append('\"');
            }
        } else {
            sb.append(this.getName() + "=" + this.getValue());
        }
        return sb.toString();
    }

    private static Cookie parseHeader(String header) {
        String value;
        String name;
        int index;
        Cookie cookie = null;
        String namevaluePair = null;
        StringTokenizer tokenizer = new StringTokenizer(header, ";");
        try {
            namevaluePair = tokenizer.nextToken();
            index = namevaluePair.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid cookie name-value pair");
            }
            name = namevaluePair.substring(0, index).trim();
            value = namevaluePair.substring(index + 1).trim();
            cookie = new Cookie(name, Cookie.removeQuote(value));
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        while (tokenizer.hasMoreTokens()) {
            namevaluePair = tokenizer.nextToken();
            index = namevaluePair.indexOf(61);
            if (index != -1) {
                name = namevaluePair.substring(0, index).trim();
                value = namevaluePair.substring(index + 1).trim();
            } else {
                name = namevaluePair.trim();
                value = null;
            }
            if (name.equals("domain")) {
                cookie.domain = value = Cookie.removeQuote(value);
                continue;
            }
            if (name.equals("max-age")) {
                try {
                    if (cookie.getMaxAge() != -1L) continue;
                    cookie.setMaxAge(Long.parseLong(value));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by parsing max-age " + nfe.toString());
                }
                continue;
            }
            if (name.equals("path")) {
                value = Cookie.removeQuote(value);
                cookie.setPath(value);
                continue;
            }
            if (name.equals("port")) {
                cookie.setPortlist(value == null ? "" : value);
                continue;
            }
            if (!name.equals("secure")) continue;
            cookie.setSecure(true);
        }
        return cookie;
    }

    private static String removeQuote(String str) {
        if (str != null && str.length() > 0 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static boolean startsWithIgnoreCase(String s, String start) {
        if (s == null || start == null) {
            return false;
        }
        return s.length() >= start.length() && start.equalsIgnoreCase(s.substring(0, start.length()));
    }
}

