/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.run;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.ui.graph.impl.SelectiveGlobalActionContext;
import com.paterva.maltego.util.ui.WindowUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class GlobalContextRunProvider
implements RunProvider {
    private static final Logger LOG = Logger.getLogger(GlobalContextRunProvider.class.getName());
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final Map<String, List<RunProviderItem>> _items = new HashMap<String, List<RunProviderItem>>();
    private final Map<String, String> _filterText = new HashMap<String, String>();
    private final AtomicBoolean _isUpdating = new AtomicBoolean(false);

    public GlobalContextRunProvider() {
        SelectiveGlobalActionContext.instance().addChangeListener(e2 -> this.updateItemsLater());
    }

    protected abstract List<RunProviderItem> createItems(String var1, GraphID var2, Set<EntityID> var3);

    protected abstract void updateFavorites();

    public List<RunProviderItem> getItems(String component) {
        List<RunProviderItem> items = this._items.get(component);
        return Collections.unmodifiableList(items);
    }

    public boolean isUpdating() {
        return this._isUpdating.get();
    }

    public void setFilterText(String component, String text) {
        String filterText = this.getFilterText(component);
        if (!Objects.equals(text, filterText)) {
            this._filterText.put(component, text);
            this.updateItemsLater();
        }
    }

    public String getFilterText(String component) {
        String filterText = this._filterText.get(component);
        return filterText != null ? filterText : "";
    }

    protected void updateItems() {
        this.updateItems("run-view");
        this.updateItems("context-menu");
    }

    protected void updateItemsDebounced() {
        if (!this._isUpdating.getAndSet(true)) {
            LOG.log(Level.FINE, "updateItemsDebounced: {0}", this);
            Timer t = new Timer(1000, __ -> this.updateAllItems());
            t.setRepeats(false);
            t.start();
        }
    }

    protected void updateItemsLater() {
        if (!this._isUpdating.getAndSet(true)) {
            LOG.log(Level.FINE, "updateItemsLater: {0}", this);
            SwingUtilities.invokeLater(() -> SwingUtilities.invokeLater(() -> this.updateAllItems()));
        }
    }

    private void updateAllItems() {
        for (String component : this._items.keySet()) {
            this.updateItems(component);
        }
        this._isUpdating.set(false);
        this.fireItemsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateItems(String component) {
        LOG.log(Level.FINE, "updateItems start: {0}", this);
        SelectiveGlobalActionContext selection = SelectiveGlobalActionContext.instance();
        GraphID graphID = selection.getTopGraphID();
        Set<EntityID> selectedModelEntities = selection.getSelectedModelEntities();
        boolean showWait = selectedModelEntities != null && selectedModelEntities.size() > 100;
        try {
            if (showWait) {
                WindowUtil.showWaitCursor();
            }
            List items = graphID != null ? this.createItems(component, graphID, selectedModelEntities) : Collections.emptyList();
            this._items.put(component, items);
            this.updateFavorites();
        }
        finally {
            if (showWait) {
                WindowUtil.hideWaitCursor();
            }
        }
        LOG.log(Level.FINE, "updateItems end: {0}", this);
    }

    protected void fireItemsChanged() {
        this._changeSupport.firePropertyChange("itemsChanged", null, this._items);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }
}

