/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.HelpCtx;

public class EditNodeAction
extends TopGraphSelectionContextAction {
    @Override
    protected void actionPerformed(GraphView graphView) {
        GraphID graphID = this.getTopGraphID();
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set entities = selection.getSelectedModelEntities();
        if (entities.size() == 1) {
            EntityID entityID = (EntityID)entities.iterator().next();
            SwingUtilities.invokeLater(() -> NodeEditor.getDefault().edit(graphID, entityID));
        } else {
            Set links = selection.getSelectedModelLinks();
            if (links.size() == 1) {
                LinkID linkID = (LinkID)links.iterator().next();
                SwingUtilities.invokeLater(() -> NodeEditor.getDefault().edit(graphID, linkID));
            }
        }
    }

    public String getName() {
        return "Properties...";
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/EditEntityNode.png";
    }
}

