/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.RichToolTipManager;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;

public abstract class AbstractCommandButton
extends RichToolTipManager.JTrackableComponent {
    protected ResizableIcon icon;
    protected ResizableIcon disabledIcon;
    private String text;
    protected ActionButtonModel actionModel;
    protected String extraText;
    protected CommandButtonDisplayState displayState;
    protected int customDimension;
    protected boolean isFlat;
    private int horizontalAlignment;
    private double hgapScaleFactor;
    private double vgapScaleFactor;
    private RichTooltip actionRichTooltip;
    private CommandButtonLocationOrderKind locationOrderKind;
    protected ActionHandler actionHandler;
    protected String actionKeyTip;

    public AbstractCommandButton(String text, ResizableIcon icon) {
        this.icon = icon;
        this.customDimension = -1;
        this.displayState = CommandButtonDisplayState.FIT_TO_ICON;
        this.horizontalAlignment = 0;
        this.actionHandler = new ActionHandler();
        this.isFlat = true;
        this.hgapScaleFactor = 1.0;
        this.vgapScaleFactor = 1.0;
        this.setText(text);
        this.setOpaque(false);
    }

    public void setUI(CommandButtonUI ui) {
        super.setUI(ui);
    }

    @Override
    public CommandButtonUI getUI() {
        return (CommandButtonUI)this.ui;
    }

    public void setDisplayState(CommandButtonDisplayState state) {
        CommandButtonDisplayState old = this.displayState;
        this.displayState = state;
        this.firePropertyChange("displayState", old, this.displayState);
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ResizableIcon defaultIcon) {
        ResizableIcon oldValue = this.icon;
        this.icon = defaultIcon;
        this.firePropertyChange("icon", oldValue, defaultIcon);
        if (defaultIcon != oldValue) {
            if (defaultIcon == null || oldValue == null || defaultIcon.getIconWidth() != oldValue.getIconWidth() || defaultIcon.getIconHeight() != oldValue.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setDisabledIcon(ResizableIcon disabledIcon) {
        this.disabledIcon = disabledIcon;
    }

    public ResizableIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public CommandButtonDisplayState getDisplayState() {
        return this.displayState;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public void setExtraText(String extraText) {
        String oldValue = this.extraText;
        this.extraText = extraText;
        this.firePropertyChange("extraText", oldValue, extraText);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, extraText);
        }
        if (extraText == null || oldValue == null || !extraText.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange("text", oldValue, text);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, text);
        }
        if (text == null || oldValue == null || !text.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void updateCustomDimension(int dimension) {
        if (this.customDimension != dimension) {
            int old = this.customDimension;
            this.customDimension = dimension;
            this.firePropertyChange("customDimension", old, this.customDimension);
        }
    }

    public int getCustomDimension() {
        return this.customDimension;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public void setFlat(boolean isFlat) {
        boolean old = this.isFlat;
        this.isFlat = isFlat;
        if (old != this.isFlat) {
            this.firePropertyChange("flat", old, this.isFlat);
        }
        if (old != isFlat) {
            this.repaint();
        }
    }

    public ActionButtonModel getActionModel() {
        return this.actionModel;
    }

    public void setActionModel(ActionButtonModel newModel) {
        ActionButtonModel oldModel = this.getActionModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.actionHandler);
            oldModel.removeActionListener(this.actionHandler);
        }
        this.actionModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.actionHandler);
            newModel.addActionListener(this.actionHandler);
        }
        this.firePropertyChange("actionModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b && this.actionModel.isRollover()) {
            this.actionModel.setRollover(false);
        }
        super.setEnabled(b);
        this.actionModel.setEnabled(b);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(ce);
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHGapScaleFactor(double hgapScaleFactor) {
        if (hgapScaleFactor == this.hgapScaleFactor) {
            return;
        }
        double oldValue = this.hgapScaleFactor;
        this.hgapScaleFactor = hgapScaleFactor;
        this.firePropertyChange("hgapScaleFactor", oldValue, this.hgapScaleFactor);
        if (this.hgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setVGapScaleFactor(double vgapScaleFactor) {
        if (vgapScaleFactor == this.vgapScaleFactor) {
            return;
        }
        double oldValue = this.vgapScaleFactor;
        this.vgapScaleFactor = vgapScaleFactor;
        this.firePropertyChange("vgapScaleFactor", oldValue, this.vgapScaleFactor);
        if (this.vgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setGapScaleFactor(double gapScaleFactor) {
        this.setHGapScaleFactor(gapScaleFactor);
        this.setVGapScaleFactor(gapScaleFactor);
    }

    public double getHGapScaleFactor() {
        return this.hgapScaleFactor;
    }

    public double getVGapScaleFactor() {
        return this.vgapScaleFactor;
    }

    public void doActionClick() {
        Dimension size = this.getSize();
        ActionButtonModel actionModel = this.getActionModel();
        actionModel.setArmed(true);
        actionModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        actionModel.setPressed(false);
        actionModel.setArmed(false);
    }

    boolean hasRichTooltips() {
        return this.actionRichTooltip != null;
    }

    public void setActionRichTooltip(RichTooltip richTooltip) {
        this.actionRichTooltip = richTooltip;
        RichToolTipManager richToolTipManager = RichToolTipManager.sharedInstance();
        if (this.hasRichTooltips()) {
            richToolTipManager.registerComponent(this);
        } else {
            richToolTipManager.unregisterComponent(this);
        }
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.actionRichTooltip;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
    }

    public CommandButtonLocationOrderKind getLocationOrderKind() {
        return this.locationOrderKind;
    }

    public void setLocationOrderKind(CommandButtonLocationOrderKind locationOrderKind) {
        CommandButtonLocationOrderKind old = this.locationOrderKind;
        if (old != locationOrderKind) {
            this.locationOrderKind = locationOrderKind;
            this.firePropertyChange("locationOrderKind", (Object)old, (Object)this.locationOrderKind);
        }
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public void setActionKeyTip(String actionKeyTip) {
        String old = this.actionKeyTip;
        this.actionKeyTip = actionKeyTip;
        this.firePropertyChange("actionKeyTip", old, this.actionKeyTip);
    }

    class ActionHandler
    implements ActionListener,
    ChangeListener {
        ActionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractCommandButton.this.fireStateChanged();
            AbstractCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractCommandButton.this.fireActionPerformed(event);
        }
    }

    public static enum CommandButtonLocationOrderKind {
        ONLY,
        FIRST,
        MIDDLE,
        LAST;

    }
}

