/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.graph.ConnectivityController;
import com.paterva.maltego.graph.table.ui.table.ConnectivityTableController;
import com.paterva.maltego.graph.table.ui.wizard.EntityMappingController;
import com.paterva.maltego.graph.table.ui.wizard.LinkMappingController;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

public class MappingConfigurationController
extends ValidatingController<JPanel>
implements WizardDescriptor.ValidatingPanel {
    private final int _defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
    private final EntityMappingController _entityMappingController;
    private final ConnectivityController _connectivityController;
    private final ConnectivityTableController _connectivityTableController;
    private final LinkMappingController _linkMappingController;
    private final JTabbedPane _mcTabbedPane;
    private int _currentTabIndex = 0;
    private int _previousTabIndex = 0;
    private final PropertyChangeListener _graphListener;
    private PropertyChangeListener _weakGraphListener;

    public MappingConfigurationController() {
        this.setName("Mapping Configuration");
        this.setDescription("Configure the mapping of columns in the imported file to entities (\"Map Columns to Entities\" tab) and for two or more defined entities optionally create and edit links between them (\"Connectivity\" tab) and/or assign link properties to input file columns (\"Map Columns to Links\" tab). If a saved mapping configuration was chosen in the \"Select File\" step, the entities, links and column mappings would be pre-configured for this step.");
        this._entityMappingController = new EntityMappingController();
        this._connectivityController = new ConnectivityController();
        this._connectivityTableController = new ConnectivityTableController(this._connectivityController);
        this._linkMappingController = new LinkMappingController();
        this._mcTabbedPane = new JTabbedPane();
        Color bg = UIManager.getLookAndFeelDefaults().getColor("7-heading-panel-background");
        this._mcTabbedPane.setBackground(bg);
        this.setBackgroundColor(bg);
        this._graphListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("entityAdded") || evt.getPropertyName().equals("entityRemoved")) {
                    TabularGraph tabularGraph = (TabularGraph)evt.getSource();
                    MappingConfigurationController.this.manageTabEnable(tabularGraph);
                }
            }
        };
    }

    protected JPanel createComponent() {
        JPanel mappingConfigurationPanel = new JPanel();
        mappingConfigurationPanel.setLayout(new BoxLayout(mappingConfigurationPanel, 3));
        this._mcTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MappingConfigurationController.this._previousTabIndex = MappingConfigurationController.this._currentTabIndex;
                MappingConfigurationController.this._currentTabIndex = MappingConfigurationController.this._mcTabbedPane.getSelectedIndex();
                switch (MappingConfigurationController.this._previousTabIndex) {
                    case 0: {
                        MappingConfigurationController.this._entityMappingController.storeSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    case 1: {
                        MappingConfigurationController.this._connectivityController.storeSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    case 2: {
                        MappingConfigurationController.this._connectivityTableController.storeSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    default: {
                        MappingConfigurationController.this._linkMappingController.storeSettings(MappingConfigurationController.this.getDescriptor());
                    }
                }
                switch (MappingConfigurationController.this._currentTabIndex) {
                    case 0: {
                        MappingConfigurationController.this._entityMappingController.readSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    case 1: {
                        MappingConfigurationController.this._connectivityController.readSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    case 2: {
                        MappingConfigurationController.this._connectivityTableController.readSettings(MappingConfigurationController.this.getDescriptor());
                        break;
                    }
                    default: {
                        MappingConfigurationController.this._linkMappingController.readSettings(MappingConfigurationController.this.getDescriptor());
                    }
                }
            }
        });
        this._mcTabbedPane.addTab(this._entityMappingController.getName(), this._entityMappingController.getComponent());
        this._mcTabbedPane.addTab(this._connectivityController.getName(), this._connectivityController.getComponent());
        this._mcTabbedPane.addTab(this._connectivityTableController.getName(), this._connectivityTableController.getComponent());
        this._mcTabbedPane.addTab(this._linkMappingController.getName(), this._linkMappingController.getComponent());
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        this._weakGraphListener = WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)tabularGraph);
        tabularGraph.addPropertyChangeListener(this._weakGraphListener);
        this.manageTabEnable(tabularGraph);
        mappingConfigurationPanel.add(this._mcTabbedPane);
        return mappingConfigurationPanel;
    }

    private void manageTabEnable(TabularGraph tabularGraph) {
        if (tabularGraph.getEntities().size() > 1) {
            this._connectivityController.setDefaultLinks(tabularGraph);
            this._mcTabbedPane.setEnabledAt(1, true);
            this._mcTabbedPane.setEnabledAt(2, true);
            if (tabularGraph.getLinks().size() > 0) {
                this._mcTabbedPane.setEnabledAt(3, true);
            }
        } else {
            this._mcTabbedPane.setEnabledAt(1, false);
            this._mcTabbedPane.setEnabledAt(2, false);
            this._mcTabbedPane.setEnabledAt(3, false);
            this._mcTabbedPane.setSelectedIndex(0);
        }
    }

    protected void readSettings(WizardDescriptor settings) {
        ToolTipManager.sharedInstance().setDismissDelay(12000);
        this._entityMappingController.readSettings(settings);
        this._connectivityController.readSettings(settings);
        this._connectivityTableController.readSettings(settings);
        this._linkMappingController.readSettings(settings);
        this.component();
        if (this._mcTabbedPane.getTabCount() >= 4) {
            TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
            tabularGraph.removePropertyChangeListener(this._graphListener);
            this._weakGraphListener = WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)tabularGraph);
            tabularGraph.addPropertyChangeListener(this._weakGraphListener);
            this.manageTabEnable(tabularGraph);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        ToolTipManager.sharedInstance().setDismissDelay(this._defaultDismissTimeout);
        this._entityMappingController.storeSettings(settings);
        this._connectivityController.storeSettings(settings);
        this._connectivityTableController.storeSettings(settings);
        this._linkMappingController.storeSettings(settings);
    }

    public void validate() throws WizardValidationException {
        this._entityMappingController.validate();
        this._linkMappingController.validate();
    }

    public JTabbedPane getMappingConfigurationTabbedPane() {
        return this._mcTabbedPane;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }
}

