/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.box;

import com.paterva.maltego.chat.box.Bundle;
import com.paterva.maltego.chat.box.ChatInputPanel;
import com.paterva.maltego.chat.box.ChatOutputPanel;
import com.paterva.maltego.chat.box.ChatWindowAddOns;
import com.paterva.maltego.chat.box.InputListener;
import com.paterva.maltego.chat.files.FileReceivePanel;
import com.paterva.maltego.chat.files.FileSendPanel;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.conn.ConnectionStatusEvent;
import com.paterva.maltego.chatapi.conn.ConnectionStatusListener;
import com.paterva.maltego.chatapi.file.FileTransferController;
import com.paterva.maltego.chatapi.file.receive.FileReceiveOperation;
import com.paterva.maltego.chatapi.file.send.FileSendOperation;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.output.OutputMessage;
import com.paterva.maltego.util.ui.output.PrintMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class ChatHistoryPanel
extends JPanel {
    private ChatRoom _chatRoom;
    private ChatOutputPanel _chatOutputPanel;
    private InputOutput _chatOutput;
    private FileTransferListener _fileTransferListener;
    private JPanel _filesPanel;
    private AddOnsListener _addOnsListener;
    private JPanel _addOnsPanel;
    private ChatInputPanel _chatInput;
    private String _previousTimeStr;
    private int _messagesInTransit = 0;
    private Timer _transitTimeoutTimer = new Timer(15000, new TransitTimeoutListener());
    private ConnectionStatusListener _connListener = new ConnectionListener();
    private OutputKeyDispatcher _outputKeyDispatcher;

    public ChatHistoryPanel(ChatRoom chatRoom) {
        this._transitTimeoutTimer.setRepeats(false);
        this.setLayout(new BorderLayout());
        this._chatRoom = chatRoom;
        this._chatOutputPanel = new ChatOutputPanel();
        IOContainer ioContainer = IOContainer.create((IOContainer.Provider)this._chatOutputPanel);
        this._chatOutput = IOProvider.getDefault().getIO("ChatOutput", new Action[0], ioContainer);
        this.add(this._chatOutputPanel);
        try {
            this._chatOutput.getOut().reset();
        }
        catch (IOException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        JPanel bottomPanel2 = new JPanel(new BorderLayout());
        this._addOnsPanel = new JPanel();
        this._addOnsPanel.setBackground(Color.WHITE);
        this._addOnsPanel.setLayout(new BoxLayout(this._addOnsPanel, 1));
        this.add((Component)this._addOnsPanel, "North");
        this._filesPanel = new JPanel();
        this._filesPanel.setLayout(new BoxLayout(this._filesPanel, 1));
        bottomPanel2.add((Component)this._filesPanel, "South");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add(bottomPanel2);
        this._chatInput = new ChatInputPanel();
        this._chatInput.addChatListener(new ChatInputListener());
        bottomPanel.add((Component)this._chatInput, "South");
        this.add((Component)bottomPanel, "South");
    }

    private void addListeners() {
        FileTransferController fileTransferController = this._chatRoom.getFileTransferController();
        if (fileTransferController != null) {
            this._fileTransferListener = new FileTransferListener();
            fileTransferController.addPropertyChangeListener((PropertyChangeListener)this._fileTransferListener);
            this.refreshFiles();
        }
        ChatWindowAddOns addOns = ChatWindowAddOns.getDefault();
        this.refreshAddOns(addOns);
        this._addOnsListener = new AddOnsListener();
        addOns.addPropertyChangeListener(this._chatRoom, this._addOnsListener);
        this._messagesInTransit = 0;
        this._chatRoom.addConnectionStatusListener(this._connListener);
        this._outputKeyDispatcher = new OutputKeyDispatcher();
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._outputKeyDispatcher);
    }

    private void removeListeners() {
        FileTransferController fileTransferController = this._chatRoom.getFileTransferController();
        if (fileTransferController != null) {
            fileTransferController.removePropertyChangeListener((PropertyChangeListener)this._fileTransferListener);
            this._fileTransferListener = null;
        }
        this._filesPanel.removeAll();
        ChatWindowAddOns addOns = ChatWindowAddOns.getDefault();
        addOns.removePropertyChangeListener(this._chatRoom, this._addOnsListener);
        this._addOnsListener = null;
        this._addOnsPanel.removeAll();
        this._chatRoom.removeConnectionStatusListener(this._connListener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._outputKeyDispatcher);
        this._outputKeyDispatcher = null;
    }

    public void requestInputFocus() {
        this._chatInput.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateChatEnabled();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    public void chatMessage(User user, OutputMessage message, Date date) {
        if (this._chatRoom.getClientUser().equals(user)) {
            if (this._messagesInTransit > 0) {
                --this._messagesInTransit;
            }
            if (this._messagesInTransit > 0) {
                this._transitTimeoutTimer.restart();
            } else if (this._transitTimeoutTimer.isRunning()) {
                this._transitTimeoutTimer.stop();
            }
            this._chatInput.setMessagesInTransit(this._messagesInTransit);
        }
        try {
            this.printTime(date);
            IOColorPrint.print((InputOutput)this._chatOutput, (CharSequence)(this._chatRoom.getAlias(user) + ": "), (Color)Color.decode(Bundle.CTL_UserNameColor()));
            PrintMessage.printMessage((OutputMessage)message, (Color)Color.decode(Bundle.CTL_ChatColor()), (InputOutput)this._chatOutput, (Color)Color.decode(Bundle.CTL_LinkColor()));
            this._chatOutput.getOut().println();
        }
        catch (IOException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    public void logMessage(LogMessageLevel level, OutputMessage message, Date date) {
        Color color;
        switch (level) {
            case Debug: {
                color = Color.decode(Bundle.CTL_LogDebugColor());
                break;
            }
            case Info: {
                color = Color.decode(Bundle.CTL_LogInfoColor());
                break;
            }
            case Warning: {
                color = Color.decode(Bundle.CTL_LogWarningColor());
                break;
            }
            case Error: {
                color = Color.decode(Bundle.CTL_LogErrorColor());
                break;
            }
            default: {
                color = Color.BLACK;
            }
        }
        this.logMessage(level, message, color, date);
    }

    public void logMessage(LogMessageLevel level, OutputMessage message, Color color, Date date) {
        try {
            this.printTime(date);
            PrintMessage.printMessage((OutputMessage)message, (Color)color, (InputOutput)this._chatOutput, (Color)Color.decode(Bundle.CTL_LinkColor()));
            this._chatOutput.getOut().println();
        }
        catch (IOException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    private void printTime(Date date) throws IOException, NumberFormatException {
        String timeStr;
        if (date == null) {
            date = new Date();
        }
        Color color = (timeStr = new SimpleDateFormat("hh:mm a   ").format(date)).equals(this._previousTimeStr) ? Color.WHITE : Color.decode(Bundle.CTL_TimeColor());
        this._previousTimeStr = timeStr;
        IOColorPrint.print((InputOutput)this._chatOutput, (CharSequence)timeStr, (Color)color);
    }

    private void refreshFiles() {
        this._filesPanel.removeAll();
        FileTransferController fileTransferController = this._chatRoom.getFileTransferController();
        if (fileTransferController != null) {
            List fileSendOperations = fileTransferController.getFileSendOperations();
            for (FileSendOperation fileSendOperation : fileSendOperations) {
                this.addFilePanel(fileSendOperation);
            }
            List fileReceiveOperations = fileTransferController.getFileReceiveOperations();
            for (FileReceiveOperation fileReceiveOperation : fileReceiveOperations) {
                this.addFilePanel(fileReceiveOperation);
            }
        }
    }

    private void addFilePanel(FileSendOperation fileSendOperation) {
        FileSendPanel fileSendPanel = new FileSendPanel(this._chatRoom.getFileTransferController(), fileSendOperation);
        this._filesPanel.add(fileSendPanel);
        this.validate();
        this.repaint();
    }

    private void addFilePanel(FileReceiveOperation fileReceiveOperation) {
        FileReceivePanel fileReceivePanel = new FileReceivePanel(this._chatRoom.getFileTransferController(), fileReceiveOperation);
        this._filesPanel.add(fileReceivePanel);
        this.validate();
        this.repaint();
    }

    private void removeFilePanel(FileSendOperation fileSendOperation) {
        Component[] filePanels;
        FileSendPanel panelToRemove = null;
        for (Component filePanel : filePanels = this._filesPanel.getComponents()) {
            FileSendPanel fileSendPanel;
            if (!(filePanel instanceof FileSendPanel) || !fileSendOperation.equals((fileSendPanel = (FileSendPanel)filePanel).getFileSendOperation())) continue;
            panelToRemove = fileSendPanel;
            break;
        }
        this._filesPanel.remove(panelToRemove);
        this.validate();
        this.repaint();
    }

    private void removeFilePanel(FileReceiveOperation fileReceiveOperation) {
        Component[] filePanels;
        FileReceivePanel panelToRemove = null;
        for (Component filePanel : filePanels = this._filesPanel.getComponents()) {
            FileReceivePanel fileReceivePanel;
            if (!(filePanel instanceof FileReceivePanel) || !fileReceiveOperation.equals((fileReceivePanel = (FileReceivePanel)filePanel).getFileReceiveOperation())) continue;
            panelToRemove = fileReceivePanel;
            break;
        }
        this._filesPanel.remove(panelToRemove);
        this.validate();
        this.repaint();
    }

    private void refreshAddOns(ChatWindowAddOns addOns) {
        this._addOnsPanel.removeAll();
        for (Component addOn : addOns.get(this._chatRoom)) {
            this._addOnsPanel.add(addOn);
        }
        this.validate();
        this.repaint();
    }

    private void updateChatEnabled() {
        ConnectionStatus connStatus = this._chatRoom.getConnectionStatus();
        boolean enable = ConnectionStatus.isConnected((ConnectionStatus)connStatus);
        if (enable) {
            if (!this._chatInput.isChatEnabled()) {
                this._chatInput.restoreText();
            }
        } else {
            if (this._chatInput.isChatEnabled()) {
                this._chatInput.backupText();
            }
            this._chatInput.setText("(" + connStatus.getDisplayName() + ")");
        }
        this._chatInput.setChatEnabled(enable);
    }

    private class OutputKeyDispatcher
    implements KeyEventDispatcher {
        private OutputKeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            Component focusOwner;
            final char keyChar = e.getKeyChar();
            if (e.getID() == 400 && keyChar != '\uffff' && !e.isAltDown() && !e.isControlDown() && !e.isMetaDown() && (focusOwner = WindowManager.getDefault().getMainWindow().getFocusOwner()) != null && ChatHistoryPanel.this._chatOutputPanel.isAncestorOf(focusOwner)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChatHistoryPanel.this._chatInput.requestFocusInWindow();
                        ChatHistoryPanel.this._chatInput.addCharacter(keyChar);
                    }
                });
                return true;
            }
            return false;
        }
    }

    private class ConnectionListener
    implements ConnectionStatusListener {
        private ConnectionListener() {
        }

        public void statusChanged(ConnectionStatusEvent evt) {
            ChatHistoryPanel.this.updateChatEnabled();
        }
    }

    private class TransitTimeoutListener
    implements ActionListener {
        private TransitTimeoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatHistoryPanel.this._messagesInTransit = 0;
            ChatHistoryPanel.this._chatInput.setMessagesInTransit(ChatHistoryPanel.this._messagesInTransit);
        }
    }

    private class AddOnsListener
    implements PropertyChangeListener {
        private AddOnsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ChatHistoryPanel.this.refreshAddOns(ChatWindowAddOns.getDefault());
        }
    }

    private class FileTransferListener
    implements PropertyChangeListener {
        private FileTransferListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("newFileSendOperation".equals(evt.getPropertyName())) {
                FileSendOperation operation = (FileSendOperation)evt.getNewValue();
                ChatHistoryPanel.this.addFilePanel(operation);
            } else if ("discardFileSendOperation".equals(evt.getPropertyName())) {
                FileSendOperation operation = (FileSendOperation)evt.getOldValue();
                ChatHistoryPanel.this.removeFilePanel(operation);
            } else if ("newFileReceiveOperation".equals(evt.getPropertyName())) {
                FileReceiveOperation operation = (FileReceiveOperation)evt.getNewValue();
                ChatHistoryPanel.this.addFilePanel(operation);
            } else if ("discardFileReceiveOperation".equals(evt.getPropertyName())) {
                FileReceiveOperation operation = (FileReceiveOperation)evt.getOldValue();
                ChatHistoryPanel.this.removeFilePanel(operation);
            }
        }
    }

    private class ChatInputListener
    implements InputListener {
        private ChatInputListener() {
        }

        @Override
        public void inputMessage(String message) {
            OutputMessage chatMessage = new OutputMessage(message);
            ChatHistoryPanel.this._chatRoom.sendChat(ChatHistoryPanel.this._chatRoom.getClientUser(), chatMessage);
            if ("!test the transmit progress timeout!".equals(message)) {
                ++ChatHistoryPanel.this._messagesInTransit;
            }
            ChatHistoryPanel.this._chatInput.setMessagesInTransit(++ChatHistoryPanel.this._messagesInTransit);
            ChatHistoryPanel.this._transitTimeoutTimer.restart();
        }
    }
}

