/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.startup;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.startup.Bundle;
import org.netbeans.modules.extexecution.startup.StartupExtenderRegistrationOptions;
import org.netbeans.spi.extexecution.startup.StartupExtenderImplementation;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class StartupExtender {
    private static final Logger LOG = Logger.getLogger(StartupExtender.class.getName());
    private final String description;
    private final List<String> arguments;
    private final List<String> rawArguments;

    private StartupExtender(String description, List<String> arguments, List<String> rawArguments) {
        this.description = description;
        this.arguments = arguments;
        this.rawArguments = rawArguments;
    }

    @NonNull
    public static List<StartupExtender> getExtenders(@NonNull Lookup context, @NonNull StartMode mode) {
        Parameters.notNull((CharSequence)"context", (Object)context);
        Parameters.notNull((CharSequence)"mode", (Object)((Object)mode));
        LOG.log(Level.FINE, "getExtenders: context={0} mode={1}", new Object[]{context, mode});
        Lookup lkp = Lookups.forPath((String)"StartupExtender");
        ArrayList<StartupExtender> res = new ArrayList<StartupExtender>();
        for (Lookup.Item item : lkp.lookupResult(StartupExtenderImplementation.class).allItems()) {
            List<String> rawArgs;
            StartupExtenderImplementation impl = (StartupExtenderImplementation)item.getInstance();
            List<String> args = impl.getArguments(context, mode);
            if (!(impl instanceof StartupExtenderRegistrationOptions) || ((StartupExtenderRegistrationOptions)((Object)impl)).argumentsQuoted()) {
                rawArgs = new ArrayList<String>(args.size());
                for (String s : args) {
                    CharSequence[] parsed = BaseUtilities.parseParameters((String)s);
                    rawArgs.add(String.join((CharSequence)" ", parsed));
                }
            } else {
                rawArgs = args;
                ArrayList<String> quotedArgs = new ArrayList<String>();
                for (String s : args) {
                    if (s.isEmpty()) {
                        quotedArgs.add(s);
                        continue;
                    }
                    quotedArgs.add(BaseUtilities.escapeParameters((String[])new String[]{s}));
                }
                args = quotedArgs;
            }
            StartupExtender extender = new StartupExtender(item.getDisplayName(), args, rawArgs);
            LOG.log(Level.FINE, " {0} => {1}", new Object[]{extender.description, extender.getArguments()});
            res.add(extender);
        }
        return res;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getRawArguments() {
        return this.rawArguments;
    }

    public static enum StartMode {
        NORMAL(Bundle.StartMode_Normal()),
        DEBUG(Bundle.StartMode_Debug()),
        PROFILE(Bundle.StartMode_Profile()),
        TEST_NORMAL(Bundle.StartMode_Test_Normal()),
        TEST_DEBUG(Bundle.StartMode_Test_Debug()),
        TEST_PROFILE(Bundle.StartMode_Test_Profile());

        private final String mode;

        private StartMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

