/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.compact;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.serializers.GraphConnectionSource;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.ViewPositionSource;
import com.paterva.maltego.serializers.compact.CompactGraphNameMappings;
import com.paterva.maltego.serializers.compact.SerializedGraph;
import com.paterva.maltego.serializers.compact.stubs.DisplayInfoStub;
import com.paterva.maltego.serializers.compact.stubs.DynamicPropertyStub;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.GraphSnippetStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import com.paterva.maltego.serializers.compact.stubs.PartStub;
import com.paterva.maltego.serializers.compact.stubs.PathStub;
import com.paterva.maltego.serializers.compact.stubs.PositionStub;
import com.paterva.maltego.serializers.compact.stubs.PropertyStub;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.openide.util.Exceptions;
import org.simpleframework.xml.core.Persister;

public class CompactGraphWriter {
    private CompactGraphNameMappings _mappings = null;

    public CompactGraphWriter(CompactGraphNameMappings mappings) {
        this._mappings = mappings;
    }

    public CompactGraphWriter() {
    }

    public void write(GraphID graphID, OutputStream os, Collection<EntityID> entities, Collection<LinkID> links, boolean ignoreDefaultValues) throws GraphSerializationException {
        if (graphID != null) {
            try {
                SerializedGraph serializedGraph = this.translate(graphID, new GraphSnippetStub(), entities, links, ignoreDefaultValues);
                Persister persister = new Persister();
                persister.write((Object)serializedGraph.getGraph(), os, "UTF-8");
            }
            catch (Exception ex) {
                throw new GraphSerializationException(ex, true);
            }
        }
    }

    public String toString(GraphID graphID, boolean ignoreDefaultValues) throws GraphSerializationException {
        return this.toString(graphID, null, null, ignoreDefaultValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(GraphID graphID, Collection<EntityID> entities, Collection<LinkID> links, boolean ignoreDefaultValues) throws GraphSerializationException {
        String str;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.write(graphID, (OutputStream)bos, entities, links, ignoreDefaultValues);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                throw new GraphSerializationException(ex, true);
            }
        }
        try {
            str = bos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new GraphSerializationException(ex, true);
        }
        return str;
    }

    public SerializedGraph translate(GraphID from, GraphSnippetStub to, Collection<EntityID> entities, Collection<LinkID> links, boolean ignoreDefaultValues) throws GraphSerializationException {
        SerializedGraph serializedGraph = new SerializedGraph();
        serializedGraph.setGraph(to);
        this.copy(from, serializedGraph, entities, links, ignoreDefaultValues);
        return serializedGraph;
    }

    public void copy(GraphID from, SerializedGraph to, boolean ignoreDefaultValues) throws GraphSerializationException {
        Set fromEntities = GraphStoreHelper.getMaltegoEntities((GraphID)from);
        Set fromLinks = GraphStoreHelper.getMaltegoLinks((GraphID)from);
        Map<EntityID, Boolean> pinned = this.getPinned(from, fromEntities);
        this.copy(fromEntities, fromLinks, null, new GraphConnectionWrapper(from), EntityRegistry.forGraphID((GraphID)from), LinkRegistry.forGraphID((GraphID)from), to, ignoreDefaultValues, pinned);
    }

    public void copy(GraphID from, SerializedGraph to, Collection<EntityID> entities, Collection<LinkID> links, boolean ignoreDefaultValues) throws GraphSerializationException {
        Set fromEntities = entities == null ? GraphStoreHelper.getMaltegoEntities((GraphID)from) : GraphStoreHelper.getMaltegoEntities((GraphID)from, entities);
        Set fromLinks = links == null ? GraphStoreHelper.getMaltegoLinks((GraphID)from) : GraphStoreHelper.getMaltegoLinks((GraphID)from, links);
        Map<EntityID, Boolean> pinned = this.getPinned(from, fromEntities);
        this.copy(fromEntities, fromLinks, null, new GraphConnectionWrapper(from), EntityRegistry.forGraphID((GraphID)from), LinkRegistry.forGraphID((GraphID)from), to, ignoreDefaultValues, pinned);
    }

    public void copy(Iterable<? extends MaltegoEntity> fromEntities, Iterable<? extends MaltegoLink> fromLinks, ViewPositionSource viewSource, GraphConnectionSource connections, EntityRegistry entityRegistry, LinkRegistry linkRegistry, SerializedGraph to, boolean ignoreDefaultValues, Map<EntityID, Boolean> pinned) throws GraphSerializationException {
        this.copyEntities(fromEntities, viewSource, entityRegistry, to, ignoreDefaultValues, pinned);
        this.copyLinks(fromLinks, connections, viewSource, linkRegistry, to, ignoreDefaultValues);
    }

    protected void copyEntities(Iterable<? extends MaltegoEntity> from, ViewPositionSource viewSource, EntityRegistry entityRegistry, SerializedGraph to, boolean ignoreDefaultValues, Map<EntityID, Boolean> pinned) throws GraphSerializationException {
        if (entityRegistry == null) {
            entityRegistry = EntityRegistry.getDefault();
        }
        for (MaltegoEntity maltegoEntity : from) {
            EntityStub es = new EntityStub();
            es.setID(((EntityID)maltegoEntity.getID()).toString());
            es.setType(maltegoEntity.getTypeName());
            this.updateFixedFields(entityRegistry, maltegoEntity, es, ignoreDefaultValues);
            this.copyDisplayInformation((MaltegoPart)maltegoEntity, es);
            if (viewSource != null) {
                this.copyViews(viewSource, maltegoEntity, es);
            }
            this.copyPropertyMappings((SpecRegistry)entityRegistry, (MaltegoPart)maltegoEntity, es);
            if (maltegoEntity.getTypeName() != null) {
                DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties((SpecRegistry)entityRegistry, (String)maltegoEntity.getTypeName());
                this.copyStaticProperties(descriptors, (MaltegoPart)maltegoEntity, es, ignoreDefaultValues);
                this.copyDynamicProperties(descriptors, (MaltegoPart)maltegoEntity, es);
            } else if (!maltegoEntity.getProperties().isEmpty()) {
                throw new GraphSerializationException("Entity type must be specified if properties are to be serialized.", true);
            }
            if (pinned != null) {
                Boolean entityPinned = pinned.get(maltegoEntity.getID());
                es.setPinned(entityPinned);
            }
            to.getGraph().add(es);
            to.add(maltegoEntity, es);
        }
    }

    protected void copyLinks(Iterable<? extends MaltegoLink> from, GraphConnectionSource connections, ViewPositionSource viewSource, LinkRegistry linkRegistry, SerializedGraph to, boolean ignoreDefaultValues) throws GraphSerializationException {
        if (linkRegistry == null) {
            linkRegistry = LinkRegistry.getDefault();
        }
        for (MaltegoLink maltegoLink : from) {
            LinkStub ls = new LinkStub();
            ls.setID(((LinkID)maltegoLink.getID()).toString());
            ls.setType(maltegoLink.getTypeName());
            this.copyDisplayInformation((MaltegoPart)maltegoLink, ls);
            if (viewSource != null) {
                this.copyPaths(viewSource, maltegoLink, ls);
            }
            ls.setFrom(this.getID((Guid)connections.getSource((LinkID)maltegoLink.getID())));
            ls.setTo(this.getID((Guid)connections.getTarget((LinkID)maltegoLink.getID())));
            ls.setReversed(maltegoLink.isReversed());
            this.copyPropertyMappings((SpecRegistry)linkRegistry, (MaltegoPart)maltegoLink, ls);
            if (maltegoLink.getTypeName() != null) {
                DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties((SpecRegistry)linkRegistry, (String)maltegoLink.getTypeName());
                this.copyStaticProperties(descriptors, (MaltegoPart)maltegoLink, ls, ignoreDefaultValues);
                this.copyDynamicProperties(descriptors, (MaltegoPart)maltegoLink, ls);
            } else if (!maltegoLink.getProperties().isEmpty()) {
                throw new GraphSerializationException("Link type must be specified if properties are to be serialized.", true);
            }
            this.convertLinkNames(ls);
            to.getGraph().add(ls);
            to.add(maltegoLink, ls);
        }
    }

    private void convertLinkNames(LinkStub ls) {
        if (this._mappings != null) {
            ls.setDisplayValueExpression(this._mappings.linkPropNameToShortName(ls.getDisplayValueExpression()));
            ls.setValuePropertyName(this._mappings.linkPropNameToShortName(ls.getValuePropertyName()));
            for (PropertyStub propertyStub : ls.getProperties()) {
                propertyStub.setName(this._mappings.linkPropNameToShortName(propertyStub.getName()));
            }
            for (PropertyStub propertyStub : ls.getDynamicProperties()) {
                propertyStub.setName(this._mappings.linkPropNameToShortName(propertyStub.getName()));
            }
            ls.setType(this._mappings.linkTypeNameToShortName(ls.getType()));
        }
    }

    private String getID(Guid id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    private void copyPaths(ViewPositionSource source, MaltegoLink link, LinkStub stub) {
        Collection<String> views = source.getViews();
        for (String view : views) {
            List<Point> path = source.getPath(view, (LinkID)link.getID());
            if (path == null) continue;
            stub.add(new PathStub(view, this.pathToString(path)));
        }
    }

    private String pathToString(List<Point> path) {
        StringBuilder buffer = new StringBuilder();
        for (Point p : path) {
            buffer.append(this.getCenter(p));
            buffer.append(";");
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    private void copyStaticProperties(DisplayDescriptorCollection descriptors, MaltegoPart part, PartStub stub, boolean ignoreDefaultValues) {
        for (DisplayDescriptor dd : descriptors) {
            if (!part.getProperties().contains((PropertyDescriptor)dd)) continue;
            Object value = part.getValue((PropertyDescriptor)dd);
            if (ignoreDefaultValues && this.areEqual(value, dd.getDefaultValue())) continue;
            String stringValue = this.convertToString(value, dd.getTypeDescriptor());
            stringValue = XMLEscapeUtils.escapeUnicode((String)stringValue);
            String name = XMLEscapeUtils.escapeUnicode((String)dd.getName());
            stub.add(new PropertyStub(name, stringValue));
        }
    }

    private void copyViews(ViewPositionSource source, MaltegoEntity entity, EntityStub stub) {
        if (source != null) {
            Collection<String> views = source.getViews();
            for (String view : views) {
                Point point = source.getCenter(view, (EntityID)entity.getID());
                if (point == null) continue;
                stub.addCenter(new PositionStub(view, this.getCenter(point)));
            }
        }
    }

    private String getCenter(Point point) {
        if (point == null) {
            return null;
        }
        return String.format("%d,%d", point.x, point.y);
    }

    private void copyDynamicProperties(DisplayDescriptorCollection descriptors, MaltegoPart part, PartStub stub) {
        for (PropertyDescriptor pd : part.getProperties()) {
            Object value = part.getValue(pd);
            if (descriptors.contains(pd.getName()) || !this.include(pd.getName())) continue;
            TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
            String stringValue = this.convertToString(value, td);
            DynamicPropertyStub dps = this.translateDynamic(pd, stringValue);
            stub.add(dps);
        }
    }

    public DynamicPropertyStub translateDynamic(PropertyDescriptor pd, String stringValue) {
        TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
        stringValue = XMLEscapeUtils.escapeUnicode((String)stringValue);
        String name = XMLEscapeUtils.escapeUnicode((String)pd.getName());
        DynamicPropertyStub dps = new DynamicPropertyStub(name, stringValue);
        dps.setType(td.getTypeName());
        dps.setHidden(this.convertOptional(pd.isHidden(), false));
        dps.setNullable(this.convertOptional(pd.isNullable(), true));
        dps.setReadOnly(this.convertOptional(pd.isReadonly(), false));
        String displayName = XMLEscapeUtils.escapeUnicode((String)this.getNonEmptyString(pd.getDisplayName(), pd.getName()));
        dps.setDisplayName(displayName);
        return dps;
    }

    private void copyPropertyMappings(SpecRegistry registry, MaltegoPart from, PartStub to) {
        String valuePropertyStr = null;
        String displayExpr = null;
        if (from.getTypeName() != null) {
            PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)from, (boolean)false);
            valuePropertyStr = valueProperty == null ? null : valueProperty.getName();
            displayExpr = InheritanceHelper.getDisplayValueExpression((SpecRegistry)registry, (TypedPropertyBag)from);
        }
        to.setValuePropertyName(valuePropertyStr);
        to.setDisplayValueExpression(displayExpr);
    }

    private void copyDisplayInformation(MaltegoPart from, PartStub to) {
        if (from.getDisplayInformation() != null) {
            for (DisplayInformation di : from.getDisplayInformation()) {
                DisplayInfoStub dis = new DisplayInfoStub();
                dis.setName(XMLEscapeUtils.escapeUnicode((String)di.getName()));
                dis.setValue(XMLEscapeUtils.escapeUnicode((String)di.getValue()));
                to.add(dis);
            }
        }
    }

    private Map<EntityID, Boolean> getPinned(GraphID from, Set<MaltegoEntity> entities) throws GraphSerializationException {
        Map pinned;
        try {
            Set entityIDs = GraphStoreHelper.getIds(entities);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(from);
            pinned = graphStore.getGraphStructureStore().getStructureReader().getPinned((Collection)entityIDs);
        }
        catch (GraphStoreException ex) {
            throw new GraphSerializationException("Error getting pinned states", ex, true);
        }
        return pinned;
    }

    private boolean include(String name) {
        return true;
    }

    private String convertToString(Object value, TypeDescriptor td) {
        if (td.getType() == String.class && value == null) {
            return "";
        }
        return td.convert(value);
    }

    private String getNonEmptyString(String s, String defaultValue) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.equals(defaultValue)) {
            return null;
        }
        return s;
    }

    private String convertOptional(boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            return null;
        }
        return Boolean.toString(value);
    }

    private void updateFixedFields(EntityRegistry registry, MaltegoEntity from, EntityStub to, boolean copyDefaults) {
        String notes = XMLEscapeUtils.escapeUnicode((String)from.getNotes());
        if (copyDefaults) {
            if (from.getBookmark() >= 0) {
                to.setBookmark(from.getBookmarkValue());
            }
            if (!StringUtilities.isNullOrEmpty((String)notes) || from.isShowNotes()) {
                to.setNote(notes, from.isShowNotesValue());
            }
        } else {
            to.setBookmark(from.getBookmarkValue());
            to.setNote(notes, from.isShowNotesValue());
        }
        to.setWeight(from.getWeightValue().orElse(null));
        to.setImageExpression(from.getNonBlankImageExpression().orElse(null));
    }

    private boolean areEqual(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null) {
            return value2.equals(value1);
        }
        return value1.equals(value2);
    }

    private static class GraphConnectionWrapper
    implements GraphConnectionSource {
        private GraphStructureReader _structureReader;

        public GraphConnectionWrapper(GraphID graphID) {
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                this._structureReader = graphStore.getGraphStructureStore().getStructureReader();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public EntityID getSource(LinkID linkID) {
            EntityID entityID = null;
            try {
                entityID = this._structureReader.getSource(linkID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return entityID;
        }

        @Override
        public EntityID getTarget(LinkID linkID) {
            EntityID entityID = null;
            try {
                entityID = this._structureReader.getTarget(linkID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return entityID;
        }
    }
}

