/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorCollectionAdapter;
import com.paterva.maltego.typing.PropertyDescriptorList;
import com.paterva.maltego.typing.collections.CompoundDisplayDescriptorEnumeration;
import com.paterva.maltego.typing.collections.CompoundPropertyDescriptorCollection;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public final class PropertyDescriptors {
    private PropertyDescriptors() {
    }

    public static PropertyDescriptorCollection emptySet() {
        return new Empty();
    }

    public static PropertyDescriptorCollection singleton(PropertyDescriptor pd) {
        return new Singleton(pd);
    }

    public static PropertyDescriptorCollection add(PropertyDescriptorCollection first, PropertyDescriptorCollection second) {
        return new CompoundPropertyDescriptorCollection(first, second);
    }

    public static PropertyDescriptorCollection add(DisplayDescriptorEnumeration first, PropertyDescriptorCollection second) {
        return new CompoundPropertyDescriptorCollection(new PropertyDescriptorCollectionAdapter(first), second);
    }

    public static PropertyDescriptorCollection add(PropertyDescriptorCollection first, DisplayDescriptorCollection second) {
        return new CompoundPropertyDescriptorCollection(first, new PropertyDescriptorCollectionAdapter(second));
    }

    public static DisplayDescriptorEnumeration add(DisplayDescriptorEnumeration first, DisplayDescriptorEnumeration second) {
        return new CompoundDisplayDescriptorEnumeration(first, second);
    }

    public static PropertyDescriptorCollection substract(PropertyDescriptorCollection from, PropertyDescriptorCollection what) {
        PropertyDescriptorList list = new PropertyDescriptorList();
        for (PropertyDescriptor d : from) {
            if (what.contains(d)) continue;
            list.add(d);
        }
        return list;
    }

    private static class Singleton
    extends AbstractSet<PropertyDescriptor>
    implements PropertyDescriptorCollection {
        private Set<PropertyDescriptor> _list;

        public Singleton(PropertyDescriptor pd) {
            this._list = Collections.singleton(pd);
        }

        @Override
        public boolean add(PropertyDescriptor e) {
            return false;
        }

        @Override
        public Iterator<PropertyDescriptor> iterator() {
            return this._list.iterator();
        }

        @Override
        public int size() {
            return this._list.size();
        }

        @Override
        public PropertyDescriptor get(String name) {
            for (PropertyDescriptor d : this._list) {
                if (!d.getName().equals(name)) continue;
                return d;
            }
            return null;
        }

        @Override
        public boolean contains(String name) {
            PropertyDescriptor d = this.get(name);
            return d != null;
        }

        @Override
        public boolean remove(PropertyDescriptor pd) {
            return false;
        }

        @Override
        public boolean remove(String name) {
            return false;
        }

        @Override
        public void removeAll(PropertyDescriptorCollection collection) {
        }

        @Override
        public void addAll(PropertyDescriptorCollection collection) {
        }

        @Override
        public boolean contains(PropertyDescriptor pd) {
            return this._list.contains(pd);
        }
    }

    private static class Empty
    extends AbstractSet<PropertyDescriptor>
    implements PropertyDescriptorCollection {
        @Override
        public boolean add(PropertyDescriptor e) {
            return false;
        }

        @Override
        public Iterator<PropertyDescriptor> iterator() {
            return new Iterator<PropertyDescriptor>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public PropertyDescriptor next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public PropertyDescriptor get(String name) {
            return null;
        }

        @Override
        public boolean contains(String name) {
            return false;
        }

        @Override
        public boolean remove(PropertyDescriptor pd) {
            return false;
        }

        @Override
        public boolean remove(String name) {
            return false;
        }

        @Override
        public void removeAll(PropertyDescriptorCollection collection) {
        }

        @Override
        public void addAll(PropertyDescriptorCollection collection) {
        }

        @Override
        public boolean contains(PropertyDescriptor pd) {
            return false;
        }
    }
}

