/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.impl;

import com.paterva.maltego.util.MachineIDProvider;
import com.paterva.maltego.util.ThreadUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class CmdLineMacAddressIDProvider
extends MachineIDProvider {
    private static final String[] INVALID_NAMES = new String[]{"VIRTUALBOX", "LOOPBACK", "VMWARE", "VIRTUAL", "VMNET", "DUMMY"};

    @Override
    public String[] getIDCandidates(boolean appendRnd) {
        try {
            return this.getIDCandidatesImpl();
        }
        catch (IOException ex) {
            Logger.getLogger(CmdLineMacAddressIDProvider.class.getName()).log(Level.SEVERE, null, ex);
            return new String[0];
        }
    }

    private String[] getIDCandidatesImpl() throws IOException {
        ArrayList<String> list = CmdLineMacAddressIDProvider.getInterfaces();
        if (list.isEmpty() && (list = CmdLineMacAddressIDProvider.getInterfacesImpl()).isEmpty()) {
            list = CmdLineMacAddressIDProvider.getInterfacesImpl_LastResort();
        }
        HashSet<String> set = new HashSet<String>(list);
        set.remove("00-00-00-00-00-00");
        return set.toArray(new String[set.size()]);
    }

    private static ArrayList<String> getInterfaces() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            byte[] mac = ni.getHardwareAddress();
            if (mac == null || mac.length != 6 || ni.isVirtual() || CmdLineMacAddressIDProvider.isVMMac(ni)) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 6; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            list.add(sb.toString());
        }
        return list;
    }

    private static boolean isVMMac(NetworkInterface ni) {
        if (ni.isVirtual()) {
            return true;
        }
        String displayName = ni.getDisplayName();
        for (String invalid : INVALID_NAMES) {
            if (!displayName.toUpperCase().contains(invalid)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<String> getInterfacesImpl() throws IOException {
        ArrayList<String> returner;
        String type = System.getProperty("os.name");
        String[] linuxcmds = new String[]{"/sbin/ip", "/usr/local/sbin/ip", "/usr/sbin/ip", "/usr/bin/ip", "/bin/ip", "/usr/local/bin/ip"};
        String[] unixcmds = new String[]{"/sbin/ifconfig", "/usr/local/sbin/ifconfig", "/usr/sbin/ifconfig", "/usr/bin/ifconfig", "/bin/ifconfig", "/usr/local/bin/ifconfig"};
        if (type.toLowerCase().contains("windows")) {
            returner = CmdLineMacAddressIDProvider.parseInterfaces(CmdLineMacAddressIDProvider.runExt("netstat -nr"), type);
            for (int i = 0; i < returner.size(); ++i) {
                returner.set(i, returner.get(i).replace(' ', '-'));
            }
        } else {
            String output;
            String reallocation = CmdLineMacAddressIDProvider.checkIfConfigExists(linuxcmds);
            if (!reallocation.equals("no")) {
                output = CmdLineMacAddressIDProvider.runExt(reallocation + " link");
            } else {
                reallocation = CmdLineMacAddressIDProvider.checkIfConfigExists(unixcmds);
                if (reallocation.equals("no")) {
                    throw new IOException("Could not find ifconfig on this system!");
                }
                output = CmdLineMacAddressIDProvider.runExt(reallocation + " -a");
            }
            if (output.contains("CMD_ERROR")) {
                ArrayList<String> returner2 = CmdLineMacAddressIDProvider.parseInterfaces(output, type);
                if (returner2.size() <= 0) {
                    if (output.toUpperCase().contains("PERMISSION")) {
                        throw new IOException("An permission problem occured while running the command:" + output);
                    }
                    throw new IOException("An error occured while running the command:" + output);
                }
                for (int i = 0; i < returner2.size(); ++i) {
                    returner2.set(i, returner2.get(i).replace(':', '-'));
                }
                return returner2;
            }
            returner = CmdLineMacAddressIDProvider.parseInterfaces(output, type);
            for (int i = 0; i < returner.size(); ++i) {
                returner.set(i, returner.get(i).replace(':', '-'));
            }
        }
        Collections.sort(returner);
        return returner;
    }

    private static ArrayList<String> parseInterfaces(String in, String type) throws IOException {
        try {
            ArrayList<String> returner = new ArrayList<String>();
            in = in.toUpperCase().replaceAll("\r", "\n");
            String[] blobs = in.split("\n");
            if (!type.toLowerCase().contains("windows")) {
                for (String blob : blobs) {
                    String group;
                    Pattern pattern;
                    Matcher matcher;
                    if (blob.startsWith("PAN") || blob.contains("VMNET") || blob.contains("VIRTUALBOX") || blob.contains("LOOPBACK") || blob.contains("DUMMY") || !(matcher = (pattern = Pattern.compile("\\w{2}:\\w{2}:\\w{2}:\\w{2}:\\w{2}:\\w{2}")).matcher(blob)).find() || "00 00 00 00 00 00".equals(group = matcher.group().trim())) continue;
                    returner.add(group);
                }
            } else {
                for (String blob : blobs) {
                    if (blob.contains("VMWARE VIRTUAL") || blob.contains("VIRTUALBOX") || blob.contains("LOOPBACK")) continue;
                    Pattern pattern = Pattern.compile("\\w{2} \\w{2} \\w{2} \\w{2} \\w{2} \\w{2}");
                    Matcher matcher = pattern.matcher(blob);
                    while (matcher.find()) {
                        returner.add(matcher.group());
                    }
                }
            }
            return returner;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IOException("It was in here" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runExt(String command) throws IOException {
        BufferedReader stdInput = null;
        BufferedReader stdError = null;
        try {
            String s;
            String ret = "";
            Process p = Runtime.getRuntime().exec(command);
            stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                ret = ret + s + "\n";
            }
            while ((s = stdError.readLine()) != null) {
                ret = ret + "CMD_ERROR:" + s + "\n";
            }
            String string = ret;
            return string;
        }
        finally {
            if (stdInput != null) {
                try {
                    stdInput.close();
                }
                catch (IOException iOException) {}
            }
            if (stdError != null) {
                try {
                    stdError.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String checkIfConfigExists(String[] locations) {
        for (String location : locations) {
            File f = new File(location);
            if (!f.exists()) continue;
            return location;
        }
        return "no";
    }

    private static ArrayList<String> getInterfacesImpl_LastResort() throws IOException {
        ArrayList<String> interfaces = new ArrayList<String>();
        String type = System.getProperty("os.name").toLowerCase();
        Path tmpDirPath = Files.createTempDirectory("maltego_" + System.currentTimeMillis(), new FileAttribute[0]);
        File tmpDir = tmpDirPath.toFile();
        tmpDir.mkdirs();
        File FILE_COMMAND_OUTPUT = new File(tmpDir, "command_output.txt");
        File FILE_COMMAND_TEST = CmdLineMacAddressIDProvider.populateCommandTestFile(tmpDir, FILE_COMMAND_OUTPUT, type);
        if (FILE_COMMAND_TEST == null) {
            return interfaces;
        }
        Process p = CmdLineMacAddressIDProvider.executeCommandFile(FILE_COMMAND_TEST, type);
        if (p == null) {
            return interfaces;
        }
        if (!CmdLineMacAddressIDProvider.waitForResultsToBePublishedToFile(FILE_COMMAND_OUTPUT)) {
            return interfaces;
        }
        String outputFromFile = CmdLineMacAddressIDProvider.readOutputFromFile(FILE_COMMAND_OUTPUT);
        interfaces = CmdLineMacAddressIDProvider.parseInterfaces(outputFromFile, type);
        CmdLineMacAddressIDProvider.filterInterfaces(interfaces, type);
        FileUtils.deleteQuietly((File)tmpDir);
        return interfaces;
    }

    private static void filterInterfaces(ArrayList<String> interfaces, String type) {
        if (type.contains("windows")) {
            for (int i = 0; i < interfaces.size(); ++i) {
                interfaces.set(i, interfaces.get(i).replace(' ', '-'));
            }
        } else {
            for (int i = 0; i < interfaces.size(); ++i) {
                interfaces.set(i, interfaces.get(i).replace(':', '-'));
            }
        }
    }

    private static String readOutputFromFile(File outputFile) throws IOException {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        try (FileReader fr = new FileReader(outputFile);
             BufferedReader br = new BufferedReader(fr);){
            String s;
            while ((s = br.readLine()) != null) {
                sb.append(s).append(LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private static boolean waitForResultsToBePublishedToFile(File outputFile) {
        int hitLimit = 10;
        while (--hitLimit >= 0 && !outputFile.exists() && outputFile.length() == 0L) {
            ThreadUtil.sleep(250L);
        }
        ThreadUtil.sleep(100L);
        return outputFile.exists() && outputFile.length() > 0L;
    }

    private static Process executeCommandFile(File commandFile, String type) throws IOException {
        if (type.contains("windows")) {
            return Runtime.getRuntime().exec("cmd /c start " + commandFile.getAbsolutePath());
        }
        return Runtime.getRuntime().exec("sh " + commandFile.getAbsolutePath());
    }

    private static File populateCommandTestFile(File parentDir, File destinationFile, String type) throws IOException {
        String contents;
        String extention;
        if (type.contains("windows")) {
            extention = ".cmd";
            contents = "cmd /c netstat -nr > " + destinationFile.getAbsolutePath() + " & exit";
        } else if (type.contains("linux")) {
            extention = ".sh";
            contents = "ip link > " + destinationFile.getAbsolutePath() + " & exit";
        } else {
            extention = ".sh";
            contents = "ifconfig -a > " + destinationFile.getAbsolutePath() + " & exit";
        }
        File file = new File(parentDir, "command_test" + extention);
        if (!file.createNewFile()) {
            return null;
        }
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.append(contents);
        }
        return file;
    }
}

