/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class RoundRectangleBorder
extends AbstractBorder {
    Image corner;
    float arcwidth;
    float archeight;
    int titleheight;
    boolean paintLining = false;

    public RoundRectangleBorder(float arcwidth, float archeight, int titleheight, Image titleCorner, boolean paintLining) {
        this.arcwidth = arcwidth;
        this.archeight = archeight;
        this.titleheight = titleheight;
        this.corner = titleCorner;
        this.paintLining = paintLining;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Color old = g2d.getColor();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        g2d.setColor(laf.getColor("app-border-color1"));
        g2d.fillRect(x, y, width, height);
        if (this.paintLining) {
            g2d.setColor(laf.getColor("app-border-lining"));
            g2d.drawRect(x, y, width - 1, height - 1);
        }
        g2d.setColor(old);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int size = UIManager.getLookAndFeelDefaults().getInt("SplitPane.dividerSize");
        return new Insets(3, size, size, size);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int size;
        insets.left = insets.right = (size = UIManager.getLookAndFeelDefaults().getInt("SplitPane.dividerSize"));
        insets.top = 3;
        insets.bottom = size;
        return insets;
    }
}

