/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.table.ConnectivityDataItem;
import com.paterva.maltego.graph.table.ui.table.LinkCheckBox;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.IconSize;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class ConnectivityTableModel
extends AbstractTableModel {
    public static final int PREFERRED_ROW_WIDTH = 160;
    private final JTable table;
    private final TabularGraph tg;
    private final ArrayList<ConnectivityDataItem> data;
    private final List<DefaultTabularGraphLink> removedLinks;
    private final List<DefaultTabularGraphLink> addedLinks;
    private final int iconSize = IconSize.MEDIUM.getSize();
    private final int rowHeight;

    public ConnectivityTableModel(JTable table, TabularGraph tg) {
        this.table = table;
        this.tg = tg;
        this.data = new ArrayList();
        this.removedLinks = new ArrayList<DefaultTabularGraphLink>();
        this.addedLinks = new ArrayList<DefaultTabularGraphLink>();
        this.rowHeight = this.createtRowHeight();
        table.setRowHeight(this.rowHeight);
        this.loadData();
        this.createColumns();
        this.updateTableHeaders();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        if (this.data.isEmpty()) {
            return 0;
        }
        return this.data.get(0).getCount() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == columnIndex - 1) {
            return null;
        }
        if (columnIndex > rowIndex) {
            --columnIndex;
        }
        return this.data.get(rowIndex).getTableData(columnIndex);
    }

    public List<DefaultTabularGraphLink> getRemovedLinks() {
        return this.removedLinks;
    }

    public List<DefaultTabularGraphLink> getAddedLinks() {
        return this.addedLinks;
    }

    public LinkCheckBox getLinkBox(int rowIndex, int columnIndex) {
        if (rowIndex == columnIndex - 1) {
            return null;
        }
        if (columnIndex > rowIndex) {
            --columnIndex;
        }
        return this.data.get(rowIndex).getLinkBox(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (rowIndex == -1 || columnIndex == -1) {
            return;
        }
        if (columnIndex > rowIndex) {
            --columnIndex;
        }
        boolean value = (Boolean)aValue;
        LinkCheckBox linkBox = this.data.get(rowIndex).getLinkBox(columnIndex);
        linkBox.setSelected(value);
        DefaultTabularGraphLink link = linkBox.getLink();
        if (value) {
            if (this.removedLinks.contains(link)) {
                this.removedLinks.remove(link);
            } else if (!this.graphContainsLink(link)) {
                this.addedLinks.add(link);
            }
        } else if (this.addedLinks.contains(link)) {
            this.addedLinks.remove(link);
        } else if (this.graphContainsLink(link)) {
            this.removedLinks.add(link);
        }
    }

    private boolean graphContainsLink(DefaultTabularGraphLink link) {
        return this.tg.findLink(link.getSource(), link.getTarget()) != null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0 && columnIndex - 1 != rowIndex;
    }

    private void loadData() {
        this.data.clear();
        this.addedLinks.clear();
        this.removedLinks.clear();
        List entities = this.tg.getEntities();
        for (TabularGraphEntity entity : entities) {
            int column = entity.getColumns()[0];
            PropertyDescriptor pd = entity.getProperty(column);
            String columnName = this.tg.getColumnNames()[column];
            int num = entities.indexOf(entity) + 1;
            ImageIcon icon = EntityImageFactory.getDefault().getTypeIcon(entity.getEntitySpecName(), this.iconSize, this.iconSize);
            String headerText = this.createHTMLHeader(columnName, pd != null ? pd.getDisplayName() : "");
            SampleHeader sampleHeader = new SampleHeader(icon, headerText, num);
            ConnectivityDataItem cdi = new ConnectivityDataItem(this.tg, entity, entities, sampleHeader);
            this.data.add(cdi);
        }
        this.updateLinks();
        this.fireTableDataChanged();
    }

    private void updateLinks() {
        for (TabularGraphLink link : this.tg.getLinks()) {
            TabularGraphEntity source = link.getSource();
            TabularGraphEntity target = link.getTarget();
            int rowIndex = -1;
            int colIndex = -1;
            for (int i = 0; i < this.data.size(); ++i) {
                TabularGraphEntity dciSource = this.data.get(i).getSource();
                if (source.equals(dciSource)) {
                    rowIndex = i;
                    if (colIndex >= 0) break;
                }
                if (!target.equals(dciSource)) continue;
                colIndex = i + 1;
                if (rowIndex >= 0) break;
            }
            if (rowIndex == -1 || colIndex == -1) continue;
            this.setValueAt(true, rowIndex, colIndex);
        }
    }

    private void createColumns() {
        for (int column = this.table.getColumnCount() - 1; column >= 0; --column) {
            this.table.removeColumn(this.table.getColumnModel().getColumn(column));
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = new TableColumn(i);
            if (i == 0) {
                column.setPreferredWidth(160);
            } else {
                column.setPreferredWidth(this.rowHeight);
            }
            this.table.getColumnModel().addColumn(column);
        }
    }

    private void updateTableHeaders() {
        if (this.getColumnCount() > 0) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setHeaderValue("");
            for (int column = 1; column < this.table.getColumnCount(); ++column) {
                tableColumn = this.table.getColumnModel().getColumn(column);
                tableColumn.setHeaderValue(this.data.get(column - 1).getTableData(0));
            }
            this.table.getTableHeader().revalidate();
            this.table.getTableHeader().repaint();
        }
    }

    private String createHTMLHeader(String columnName, String propertyName) {
        StringBuilder html = new StringBuilder();
        html.append("<HTML><NOBR>");
        html.append(columnName);
        html.append("<BR>");
        html.append(propertyName);
        html.append("</NOBR></HTML>");
        return html.toString();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    private int createtRowHeight() {
        int fontHeight = this.table.getFontMetrics(this.table.getFont()).getHeight();
        return Math.max(fontHeight * 2 + 12, this.iconSize + 8);
    }
}

