/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.ui.CertificateDisplayer;
import com.paterva.maltego.certificates.ui.manager.CertificateNodeAction;
import com.paterva.maltego.util.FileExtensionFileFilter;
import java.awt.HeadlessException;
import java.io.File;
import java.security.cert.X509Certificate;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

public final class CertificateOpenAction
extends CertificateNodeAction {
    private static final String DIALOG_NAME = "Import Certificates";

    public CertificateOpenAction() {
        super(DIALOG_NAME);
    }

    protected void performAction(Node[] nodes) {
        FileChooserBuilder chooserBuilder = new FileChooserBuilder(CertificateOpenAction.class).setTitle(DIALOG_NAME);
        chooserBuilder.setFileFilter((FileFilter)new FileExtensionFileFilter(CertificateOpenAction.getExtensions(), "Certificate files"));
        File[] files = this.showMultiOpenDialog(chooserBuilder);
        if (files != null) {
            for (File file : files) {
                X509Certificate cert = CertificateUtils.decode((File)file, (boolean)false, (boolean)false);
                if (cert != null) {
                    CertificateRepository certRepo = CertificateRepository.getDefault();
                    if (certRepo.contains(cert)) {
                        String msg = "Certificate for file " + file.getAbsolutePath() + " already present in Maltego.";
                        String title = file.getName() + " Certificate already present.";
                        CertificateDisplayer.showCertificateMessage(this.getPopupPresenter(), title, msg);
                        continue;
                    }
                    CertificateTrustHandler.getDefault().handleCertificate("A summary of the certificate information is shown below, with more detailed information shown on the \"Details\" tab.", new X509Certificate[]{cert}, null, true, false, false, true);
                    continue;
                }
                String msg = "";
                if (CertificateUtils.isPKCS12Certificate((File)file)) {
                    msg = "Password incorrect / ";
                }
                msg = msg + "No valid certificate could be found for file " + file.getAbsolutePath() + ". DER encoded binary X.509 & Base64 (PEM) encoded X.509 certificate files are supported.";
                String title = file.getName() + " File Invalid";
                CertificateDisplayer.showCertificateMessage(this.getPopupPresenter(), title, msg);
            }
        }
    }

    private static String[] getExtensions() {
        return new String[]{"cer", "crt", "pem", "der", "pfx", "p12", "CER", "CRT", "PEM", "DER", "PFX", "P12"};
    }

    private File[] showMultiOpenDialog(FileChooserBuilder chooserBuilder) throws HeadlessException {
        File[] files = null;
        JFileChooser chooser = chooserBuilder.createFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (0 == result) {
            files = chooser.getSelectedFiles();
        }
        return files;
    }

    protected String iconResource() {
        return "com/paterva/maltego/certificates/ui/resources/CertificateImport.png";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return true;
    }
}

