/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.controls.DateRangePicker;
import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import com.paterva.maltego.typing.types.DateRange;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class DateRangePickerAdapter
extends AbstractControlAdapter<DateRangePicker, DateRange> {
    private final String _format;

    public DateRangePickerAdapter(String format) {
        this._format = format;
    }

    @Override
    public DateRangePicker create() {
        DateRangePicker control = new DateRangePicker();
        control.setFormats(this._format);
        control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("DateRangeChanged".equals(e.getActionCommand())) {
                    DateRangePickerAdapter.this.fireActionPerformed(e);
                }
            }
        });
        return control;
    }

    @Override
    protected void set(DateRangePicker component, DateRange value) {
        DateRange date = new DateRange();
        if (value != null) {
            date = value;
        }
        component.setDateRange(date);
    }

    @Override
    protected DateRange get(DateRangePicker component) {
        DateRange dateRange = component.getDateRange();
        if (dateRange != null) {
            return dateRange;
        }
        return null;
    }

    @Override
    protected boolean empty(DateRangePicker component) {
        return component.getDateRange() == null;
    }

    @Override
    protected void setBackground(DateRangePicker component, Color color) {
        component.getEditor().setBackground(color);
    }

    @Override
    protected Color getBackground(DateRangePicker component) {
        return component.getEditor().getBackground();
    }
}

