/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphMods;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeLayoutReader;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeLayoutWriter;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class CollectionNodeLayoutStore
implements GraphLayoutStore {
    private static final Logger LOG = Logger.getLogger(CollectionNodeLayoutStore.class.getName());
    private final GraphLayoutStore _model;
    private final CollectionNodeLayoutReader _reader;
    private final CollectionNodeLayoutWriter _writer;
    private final InMemoryCollectionNodes _collectionNodes;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final GraphStoreListener _graphStoreListener;
    private GraphStore _graphStore;

    public CollectionNodeLayoutStore(GraphID graphID, InMemoryCollectionNodes collectionNodes) throws GraphStoreException {
        this._graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        this._model = this._graphStore.getGraphLayoutStore();
        this._collectionNodes = collectionNodes;
        this._reader = new CollectionNodeLayoutReader(this._model.getLayoutReader(), collectionNodes);
        this._writer = new CollectionNodeLayoutWriter(this._model.getLayoutWriter(), collectionNodes);
        this._graphStoreListener = new GraphStoreListener();
        this._graphStore.addPropertyChangeListener((PropertyChangeListener)this._graphStoreListener);
        final GraphID finalGraphID = graphID;
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(finalGraphID)) {
                    if ("graphClosing".equals(evt.getPropertyName())) {
                        CollectionNodeLayoutStore.this._graphStore.removePropertyChangeListener((PropertyChangeListener)CollectionNodeLayoutStore.this._graphStoreListener);
                    } else if ("graphClosed".equals(evt.getPropertyName())) {
                        GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                        CollectionNodeLayoutStore.this._graphStore = null;
                    }
                }
            }
        });
    }

    public GraphLayoutStore getModel() {
        return this._model;
    }

    public CollectionNodeLayoutReader getLayoutReader() {
        return this._reader;
    }

    public void syncWithModel() {
        try {
            GraphLayoutReader modelReader = this.getModel().getLayoutReader();
            GraphLayoutMods mods = new GraphLayoutMods();
            mods.getCenters().putAll(modelReader.getAllCenters());
            mods.getPaths().putAll(modelReader.getAllPaths());
            if (!mods.isEmpty()) {
                this.translateMods(mods);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public GraphLayoutWriter getLayoutWriter() {
        return this._writer;
    }

    private void translateMods(GraphLayoutMods mods) throws GraphStoreException {
        LOG.log(Level.FINE, "Layout mods {0}", mods);
        GraphLayoutMods newMods = this._collectionNodes.update(mods);
        LOG.log(Level.FINE, "New Layout mods {0}", newMods);
        this._changeSupport.firePropertyChange("layoutModified", null, newMods);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private class GraphStoreListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                GraphMods mods = (GraphMods)evt.getNewValue();
                if (mods.getLayoutMods() != null && !mods.getLayoutMods().isEmpty()) {
                    CollectionNodeLayoutStore.this.translateMods(mods.getLayoutMods());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

