/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.PositionActionComparator;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListSettings;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class TreeListMenuFactory {
    public static JPopupMenu createPopup(Collection<TreeListItem> items) {
        JPopupMenu menu = new JPopupMenu();
        List<Action> actions = TreeListMenuFactory.getActions(items);
        actions = TreeListMenuFactory.wrap(items, actions);
        int actionNum = 0;
        for (Action action : actions) {
            Boolean separate;
            if (actionNum > 0 && (separate = (Boolean)action.getValue("separate")) != null && separate.booleanValue()) {
                menu.addSeparator();
            }
            menu.add(action);
            ++actionNum;
        }
        if (!actions.isEmpty()) {
            menu.addSeparator();
        }
        JMenu subMenu = new JMenu("Descriptions");
        subMenu.add(new HideDescriptionsAction());
        subMenu.add(new ShowDescriptionsAction(true));
        subMenu.add(new ShowDescriptionsAction(false));
        menu.add(subMenu);
        return menu;
    }

    private static List<Action> getActions(Collection<TreeListItem> items) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (TreeListItem item : items) {
            for (Action action : item.getContextActions()) {
                if (actions.contains(action)) continue;
                actions.add(action);
            }
        }
        Collections.sort(actions, new PositionActionComparator());
        return actions;
    }

    private static List<Action> wrap(Collection<TreeListItem> items, List<Action> actions) {
        ArrayList<Action> wrapped = new ArrayList<Action>();
        for (Action action : actions) {
            if (action == null) {
                wrapped.add(null);
                continue;
            }
            wrapped.add(new WrappedAction((String)action.getValue("Name"), items, action));
        }
        return wrapped;
    }

    private static class ShowDescriptionsAction
    extends AbstractAction {
        private final boolean _singleLine;

        public ShowDescriptionsAction(boolean singleLine) {
            super(singleLine ? "Single Line" : "Multi Line");
            this._singleLine = singleLine;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeListSettings settings = TreeListSettings.getInstance();
            if (this._singleLine) {
                settings.showSingleLineDescriptions();
            } else {
                settings.showMultiLineDescriptions();
            }
        }
    }

    private static class HideDescriptionsAction
    extends AbstractAction {
        public HideDescriptionsAction() {
            super("Hide");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeListSettings settings = TreeListSettings.getInstance();
            settings.hideDescriptions();
        }
    }

    private static class WrappedAction
    extends AbstractAction {
        private final Collection<TreeListItem> _items;
        private final Action _action;

        public WrappedAction(String name, Collection<TreeListItem> items, Action action) {
            super(name);
            this._items = items;
            this._action = action;
        }

        @Override
        public Object getValue(String key) {
            return this._action.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e.setSource(new ArrayList<TreeListItem>(this._items));
            this._action.actionPerformed(e);
        }
    }
}

