/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.StringUtilities;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;

public class RangeClipSpinner
extends JSpinner {
    private static final Logger LOG = Logger.getLogger(RangeClipSpinner.class.getName());
    private final RangeClipFormatter formatter;
    private final DocumentFilter filter = new RangeClipFilter();

    public RangeClipSpinner(SpinnerNumberModel model) {
        super(model);
        JSpinner.NumberEditor spinnerEditor = (JSpinner.NumberEditor)this.getEditor();
        this.formatter = new RangeClipFormatter(spinnerEditor.getFormat());
        JFormattedTextField spinnerTextField = spinnerEditor.getTextField();
        spinnerTextField.setFormatterFactory(new DefaultFormatterFactory(this.formatter));
    }

    public int getMaxValue() {
        return (Integer)((SpinnerNumberModel)this.getModel()).getMaximum();
    }

    public void setMaxValue(int max) {
        ((SpinnerNumberModel)this.getModel()).setMaximum(Integer.valueOf(max));
    }

    private class RangeClipFilter
    extends DocumentFilter {
        private RangeClipFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document document = fb.getDocument();
            String docText = document.getText(0, document.getLength());
            String textAfterReplacement = StringUtilities.replace((String)docText, (int)offset, (int)length, (String)text);
            try {
                Comparable<?> value = RangeClipSpinner.this.formatter.stringToValue(textAfterReplacement);
                SpinnerNumberModel model = (SpinnerNumberModel)RangeClipSpinner.this.getModel();
                Comparable<?> minimum = model.getMinimum();
                Comparable<?> maximum = model.getMaximum();
                if (value instanceof Number) {
                    Number number = (Number)((Object)value);
                    if (minimum.compareTo(number) > 0) {
                        value = minimum;
                    } else if (maximum.compareTo(number) < 0) {
                        value = maximum;
                    }
                }
                super.replace(fb, 0, document.getLength(), String.valueOf(value), attrs);
            }
            catch (NumberFormatException | ParseException ex) {
                LOG.finest(ex.toString());
            }
        }
    }

    private class RangeClipFormatter
    extends NumberFormatter {
        public RangeClipFormatter(NumberFormat format) {
            super(format);
            this.setValueClass(RangeClipSpinner.this.getModel().getValue().getClass());
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return RangeClipSpinner.this.filter;
        }
    }
}

