/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.interop.InteropFunction;

@GenerateUncached
public abstract class ImportValueNode
extends JavaScriptBaseNode {
    public abstract Object executeWithTarget(Object var1);

    public static ImportValueNode create() {
        return ImportValueNodeGen.create();
    }

    public static ImportValueNode getUncached() {
        return ImportValueNodeGen.getUncached();
    }

    @Specialization
    static int fromInt(int value) {
        return value;
    }

    @Specialization
    static String fromString(String value) {
        return value;
    }

    @Specialization
    static boolean fromBoolean(boolean value) {
        return value;
    }

    @Specialization
    static BigInt fromBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isLongRepresentableAsInt32(value)"})
    static int fromLongToInt(long value) {
        return (int)value;
    }

    @Specialization(guards={"!isLongRepresentableAsInt32(value)"})
    static long fromLong(long value) {
        return value;
    }

    @Specialization
    static double fromDouble(double value) {
        return value;
    }

    @Specialization
    static int fromNumber(byte value) {
        return value;
    }

    @Specialization
    static int fromNumber(short value) {
        return value;
    }

    @Specialization
    static double fromNumber(float value) {
        return value;
    }

    @Specialization
    static String fromChar(char value) {
        return String.valueOf(value);
    }

    @Specialization
    static Object fromDynamicObject(DynamicObject value) {
        return value;
    }

    @Specialization
    static Object fromInteropFunction(InteropFunction value) {
        return value.getFunction();
    }

    @Specialization
    static Object fromJSException(GraalJSException value) {
        return value.getErrorObjectEager();
    }

    @Specialization(guards={"!isSpecial(value)"})
    static Object fromTruffleObject(TruffleObject value) {
        return value;
    }

    static boolean isSpecial(Object value) {
        return value instanceof InteropFunction || value instanceof GraalJSException;
    }

    @Fallback
    static Object fallbackCase(Object value) {
        throw Errors.createTypeErrorUnsupportedInteropType(value);
    }
}

