/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics.queue;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.analytics.AnalyticsSession;
import com.maltego.analytics.DeviceIDProvider;
import com.maltego.analytics.api.AnalyticsEvent;
import com.maltego.analytics.queue.UserProperties;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.util.MaltegoHelper;
import com.paterva.maltego.util.Version;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EventJson {
    @JsonProperty(value="insert_id")
    private UUID insertId;
    @JsonProperty(value="device_id")
    private UUID deviceId;
    @JsonProperty(value="session_id")
    private long sessionId;
    @JsonProperty(value="platform")
    private String platform;
    @JsonProperty(value="os_name")
    private String osName;
    @JsonProperty(value="os_version")
    private String osVersion;
    @JsonProperty(value="app_version")
    private String appVersion;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="user_properties")
    private UserProperties userProperties;
    @JsonProperty(value="event_type")
    private String eventType;
    @JsonProperty(value="time")
    private long time;
    @JsonProperty(value="event_properties")
    private Map<String, Object> eventProperties;

    static EventJson build(AnalyticsEvent ae) {
        A licenseMode = LicenseManager.A().A(false);
        UserInfo userInfo = new UserInfo(licenseMode);
        EventJson event = new EventJson();
        event.insertId = ae.getTraceId();
        event.deviceId = DeviceIDProvider.getDeviceID();
        event.sessionId = AnalyticsSession.getSessionId();
        event.platform = "Desktop";
        event.osName = MaltegoHelper.getOSName();
        event.osVersion = MaltegoHelper.getOSVersion();
        event.appVersion = Version.getCurrent().toString(false, true, true, MaltegoIdProductRestrictions.isInBeta((A)licenseMode), false);
        event.userId = userInfo.getUserId();
        event.userProperties = UserProperties.build(licenseMode);
        event.eventType = ae.getType();
        event.time = ae.getTimestamp();
        event.eventProperties = ae.getProperties();
        return event;
    }
}

