/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class BackupPreferences {
    private static final String PREF_RECOVERY_ENABLED = "recoveryEnabled";
    private static final boolean PREF_RECOVERY_ENABLED_DEFAULT = true;
    private static BackupPreferences INSTANCE;
    private final Map<String, PreferenceChangeListener> listenersMap;
    private final Preferences prefs = NbPreferences.forModule(BackupPreferences.class);

    private BackupPreferences() {
        this.listenersMap = new HashMap<String, PreferenceChangeListener>();
    }

    public static synchronized BackupPreferences getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BackupPreferences();
        }
        return INSTANCE;
    }

    public void setRecoveryEnabled(boolean enabled) {
        this.prefs.putBoolean(PREF_RECOVERY_ENABLED, enabled);
    }

    public boolean isRecoveryEnabled() {
        return this.prefs.getBoolean(PREF_RECOVERY_ENABLED, true);
    }

    public void addRecoveryEnabledListener(String listenerKey, Consumer<Boolean> listener) {
        this.removeListenerIfExists(listenerKey);
        PreferenceChangeListener pcl = evt -> {
            if (evt.getKey().equals(PREF_RECOVERY_ENABLED)) {
                listener.accept(Boolean.valueOf(evt.getNewValue()));
            }
        };
        this.listenersMap.put(listenerKey, pcl);
        this.prefs.addPreferenceChangeListener(pcl);
    }

    public void removeRecoveryEnabledListener(String listenerKey) {
        this.removeListenerIfExists(listenerKey);
    }

    private void removeListenerIfExists(String listenerKey) {
        PreferenceChangeListener pcl = this.listenersMap.get(listenerKey);
        if (pcl != null) {
            this.prefs.removePreferenceChangeListener(pcl);
            this.listenersMap.remove(listenerKey);
        }
    }
}

