/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.ExportAction;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import yguard.A.J.SA;

public class SaveAsAction
extends ExportAction {
    public SaveAsAction() {
        super("saveAs");
    }

    @Override
    protected String getExtension(AutomationContext ctx, String path) {
        return GraphFileType.PANDORA.getExtension();
    }

    @Override
    protected void export(AutomationContext ctx, Payload payload, FileObject fileObject, SA graph) throws IOException {
        GraphDataObject graphDataObject = (GraphDataObject)ctx.getTarget();
        ctx.getLogger().info("Saving graph to %s", FileUtil.getFileDisplayName((FileObject)fileObject));
        this.saveGraph(graphDataObject, graphDataObject.getGraphID(), fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph(GraphDataObject graphDataObject, GraphID graphID, FileObject file) throws IOException {
        try (BufferedOutputStream os = null;){
            os = new BufferedOutputStream(file.getOutputStream());
            graphDataObject.saveGraph(graphID, (OutputStream)os, null, null, GraphFileType.PANDORA);
            MachineMessageHandler.getDefault().info((DataObject)graphDataObject, "Graph saved as %s", FileUtil.getFileDisplayName((FileObject)file));
        }
    }
}

