/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.ui.GotoUrlAction;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StepNavigationPanel
extends JPanel {
    private TourStep tourStep = TourStep.DEFAULT;
    private Runnable nextActionRunner = () -> this.tourStep.next();
    private JButton nextButton;
    private JLabel stepNoLabel;

    public StepNavigationPanel() {
        this.initComponents();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "next");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "next");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "next");
        this.getActionMap().put("next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepNavigationPanel.this.nextButton.doClick();
            }
        });
    }

    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        String stepLabel = String.format("%d of %d", tourStep.stepId(), tourStep.totalStepCount());
        this.stepNoLabel.setText(stepLabel);
        if (tourStep.stepId() == tourStep.totalStepCount()) {
            Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(StepNavigationPanel.class, (String)"StepNavigationPanel.nextButton.closeText"));
        }
    }

    public void setCustomNextAction(Runnable nextActionRunner) {
        this.nextActionRunner = nextActionRunner;
    }

    private void initComponents() {
        this.stepNoLabel = new JLabel();
        this.nextButton = new JButton();
        JLabel learnMoreLabel = new JLabel();
        this.setOpaque(false);
        this.stepNoLabel.setFont(this.stepNoLabel.getFont().deriveFont((float)this.stepNoLabel.getFont().getSize() + 1.0f));
        this.stepNoLabel.setForeground(TutorialDefaults.COLOR_TEXT_STEP_NO);
        Mnemonics.setLocalizedText((JLabel)this.stepNoLabel, (String)NbBundle.getMessage(StepNavigationPanel.class, (String)"StepNavigationPanel.stepNoLabel.text"));
        this.nextButton.setFont(this.nextButton.getFont().deriveFont((float)this.nextButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(StepNavigationPanel.class, (String)"StepNavigationPanel.nextButton.text"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StepNavigationPanel.this.nextButtonActionPerformed(evt);
            }
        });
        learnMoreLabel.setFont(learnMoreLabel.getFont().deriveFont((float)learnMoreLabel.getFont().getSize() + 3.0f));
        learnMoreLabel.setForeground(TutorialDefaults.COLOR_TEXT);
        Mnemonics.setLocalizedText((JLabel)learnMoreLabel, (String)NbBundle.getMessage(StepNavigationPanel.class, (String)"StepNavigationPanel.learnMoreLabel.text"));
        learnMoreLabel.setCursor(new Cursor(12));
        learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StepNavigationPanel.this.learnMoreLabelMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.stepNoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 119, Short.MAX_VALUE).addComponent(learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stepNoLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextButton).addComponent(learnMoreLabel, -2, 26, -2)));
    }

    private void learnMoreLabelMouseClicked(MouseEvent evt) {
        new GotoUrlAction(this.tourStep.learnMoreLink()).actionPerformed(null);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.nextButton.setEnabled(false);
        this.nextActionRunner.run();
    }
}

