/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.ui;

import com.paterva.maltego.java.config.jre.windows.WinNetworkDriveResolver;
import com.paterva.maltego.java.config.jre.windows.WinRegistry;
import com.paterva.maltego.java.config.ui.WinDriveInfo;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

public class WinDriveUtils {
    public static boolean isDriveHidden(char driveLetter, int noDrivesRegValue) {
        return WinRegistry.isDriveHidden(driveLetter, noDrivesRegValue);
    }

    public static int noDrivesRegValue() {
        return WinRegistry.noDrivesRegValue();
    }

    public static String getNetworkPath(char driveLetter) {
        return WinNetworkDriveResolver.getNetworkPath(driveLetter + "");
    }

    public static WinDriveInfo getDriveInfo(int noDrivesRegValue) {
        HashMap<String, String> mappedHiddenDrives = new HashMap<String, String>();
        ArrayList<String> hiddenDrives = new ArrayList<String>();
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (!WinDriveUtils.isDriveHidden(c, noDrivesRegValue)) continue;
            String networkPath = WinDriveUtils.getNetworkPath(c);
            if (networkPath != null) {
                mappedHiddenDrives.put(c + "", networkPath);
            }
            hiddenDrives.add(c + "");
        }
        return new WinDriveInfo(mappedHiddenDrives, hiddenDrives);
    }

    public static void addNonHiddenBaseFolders(FileSystemView fsv, Vector<File> directories, File[] baseFolders, List<String> hiddenDrives, Map<String, String> mappedHiddenDrives) {
        WinDriveUtils.addNonHiddenBaseFolders(fsv, directories, baseFolders, true, hiddenDrives, mappedHiddenDrives, false);
    }

    public static void addNonHiddenBaseFolders(FileSystemView fsv, Vector<File> directories, File[] baseFolders, List<String> hiddenDrives, Map<String, String> mappedHiddenDrives, boolean test) {
        WinDriveUtils.addNonHiddenBaseFolders(fsv, directories, baseFolders, true, hiddenDrives, mappedHiddenDrives, test);
    }

    public static void addNonHiddenBaseFolders(FileSystemView fsv, Vector<File> directories, File[] baseFolders, boolean hideNonDirectories, List<String> hiddenDrives, Map<String, String> mappedHiddenDrives, boolean test) {
        boolean log;
        boolean bl = log = Version.getCurrent().isDevBuild() || test;
        if (log) {
            System.out.println("---");
        }
        for (File baseFolder : baseFolders) {
            WinDriveUtils.addNonHiddenBaseFolder(fsv, directories, baseFolder, hideNonDirectories, hiddenDrives, mappedHiddenDrives, log);
        }
    }

    public static void addNonHiddenBaseFolder(FileSystemView fsv, Vector<File> directories, File baseFolder, boolean hideNonDirectories, List<String> hiddenDrives, Map<String, String> mappedHiddenDrives, boolean log) {
        block10: {
            try {
                boolean hidePath = false;
                if (baseFolder != null) {
                    String baseName = baseFolder.getCanonicalPath();
                    for (String string : hiddenDrives) {
                        if (!baseName.contains(string + ":") && !baseName.toUpperCase().endsWith("Microsoft\\Windows\\Recent".toUpperCase())) continue;
                        hidePath = true;
                        break;
                    }
                    if (!hidePath) {
                        for (Map.Entry entry : mappedHiddenDrives.entrySet()) {
                            String baseNameAfter;
                            String mappedHiddenDrive = (String)entry.getKey();
                            String networkPath = (String)entry.getValue();
                            if (StringUtilities.isNullOrEmpty((String)networkPath) || baseName.equalsIgnoreCase(baseNameAfter = baseName.replace(networkPath, mappedHiddenDrive + ":"))) continue;
                            hidePath = true;
                            break;
                        }
                    }
                }
                if (hidePath || !hideNonDirectories && baseFolder == null || hideNonDirectories && !fsv.isFloppyDrive(baseFolder) && !fsv.isDrive(baseFolder) && !fsv.isComputerNode(baseFolder) && !baseFolder.isDirectory()) {
                    if (log) {
                        System.out.println("Hiding - " + baseFolder);
                    }
                } else {
                    if (log) {
                        System.out.println("Add - " + baseFolder);
                    }
                    directories.add(baseFolder);
                }
            }
            catch (Exception ex) {
                if (!log) break block10;
                System.out.println("Did NOT work - " + baseFolder);
            }
        }
    }

    public static boolean isSame(File f1, File f2, boolean root) {
        try {
            Path realPath1 = f1.toPath().toRealPath(new LinkOption[0]);
            Path realPath2 = f2.toPath().toRealPath(new LinkOption[0]);
            if (realPath1 == null || realPath2 == null) {
                return false;
            }
            Path root1 = realPath1;
            Path root2 = realPath2;
            if (root) {
                root1 = realPath1.getRoot();
                root2 = realPath2.getRoot();
                if (root1 == null || root2 == null) {
                    return false;
                }
                if (root1.equals(root2)) {
                    return true;
                }
            }
            try {
                if (Files.isSameFile(root1, root2)) {
                    return true;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

