/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.archiver.FilesArchiver;
import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.TileBuilder;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ScalablePyramidBuilder {
    private final int tileSize;
    private final int overlap;
    private final String tileFormat;
    private final String descriptorExt;

    public ScalablePyramidBuilder() {
        this(254, 1, "png", "dzi");
    }

    public ScalablePyramidBuilder(int tileSize, int overlap, String tileFormat, String descriptorExt) {
        this.tileSize = tileSize;
        this.overlap = overlap;
        this.tileFormat = tileFormat;
        this.descriptorExt = descriptorExt;
        ImageIO.setUseCache(false);
    }

    public void buildPyramid(PartialImageReader imageReader, String fileName, FilesArchiver archiver) throws IOException {
        this.buildPyramid(imageReader, fileName, archiver, 1);
    }

    public void buildPyramid(PartialImageReader imageReader, String fileName, FilesArchiver archiver, int parallelism) throws IOException {
        this.buildPyramid(imageReader, fileName, archiver, parallelism, 0.0f);
    }

    public void buildPyramid(PartialImageReader imageReader, String fileName, FilesArchiver archiver, int parallelism, float maxImageCachePercentage) throws IOException {
        new TileBuilder(this.tileSize, this.overlap, this.tileFormat, this.descriptorExt, imageReader, fileName, archiver).build(parallelism, maxImageCachePercentage);
    }
}

