# Contributing to GROOPS

We appreciate all contributions such as improving the documentation, reporting or fixing bugs,
implementing new features and answering questions from users.

## Getting Started

### Improving Documentation and Examples

Please inform us about your intention to work on the documentation by
[creating an issue](https://github.com/groops-devs/groops/issues).

When your contribution is finished, please submit a Pull Request (PR)
to https://github.com/groops-devs/groops.

Your contribution will then be reviewed.

### Reporting and Fixing Bugs

If you encounter a bug, please let us know by [filing an issue](https://github.com/groops-devs/groops/issues).
Please include as much information as possible on how to reproduce the bug
and about your software environment (operating system, compiler version, GROOPS version).

If you want to provide a bug fix, please get in contact with us before you start coding.
The best way to do so is by posting your intent in the issue related to that bug.
When your contribution is finished, please submit a Pull Request (PR)
to https://github.com/groops-devs/groops.

Your contribution will then be reviewed.

### Implementing New Features

[Create an issue](https://github.com/groops-devs/groops/issues) and we will discuss together how to
best integrate the new functionality into the existing code base.
Once we together agree on a way forward, you can go ahead and implement it.

When your contribution is implemented and tested, please submit a Pull Request (PR)
to https://github.com/groops-devs/groops.

Your contribution will then be reviewed.

Reviewing large PRs is difficult and will take time, so please be patient.

### Answering User Questions

You can answer questions from users in the
[Discussions](https://github.com/groops-devs/groops/discussions) section.
