---
myst:
  html_meta:
    keywords: LaTeX, fichiers, PDF, produire un fichier PDF, fichiers Postscript, PS to PDF, 
              convertir Postscript en PDF
---

# Comment améliorer la qualité du PDF obtenu à partir de PostScript ?

Tout PostScript classique, y compris toute sortie de `dvips`, peut être converti en PDF, 
en utilisant (par exemple) une version suffisamment récente de [Ghostscript](https://www.ghostscript.com/), 
[PStill](http://www.pstill.com/) de Frank Siegert, ou *Adobe Distiller*.

Mais, bien que cette conversion puisse (presque toujours) être faite, 
les résultats ne sont parfois pas satisfaisants : 
le problème le plus fréquent est la mauvaise présentation des glyphes des caractères 
qui composent le document. Voici quelques unes des questions abordant ces sujets (et d'autres) :

- "[](/5_fichiers/formats/fontes/mon_document_est_flou_a_cause_des_fontes_t3)", 
  traitant de la cause la plus fréquente de texte au rendu flou ;
- "[](/5_fichiers/formats/fontes/mon_document_est_flou_a_cause_de_ghostscript)" ;
- "[](/5_fichiers/formats/fontes/mon_document_est_flou_quand_je_passe_en_t1)" ;
- "[](/5_fichiers/formats/pdf/des_caracteres_manquent_dans_mon_fichier_pdf)", 
  évoquant les problèmes de version obsolète d'*Adobe Distiller* ;
- "[](/5_fichiers/formats/fontes/caracteres_bizarres_avec_dvips)" en lien avec la configuration de `dvips`.

Il convient de noter que *Adobe Reader* 6 (publié à la mi-2003), tout comme ses versions ultérieures, 
ne présente plus le "flou" évoqué dans certaines des questions mentionnées ci-dessus. 
Ces questions seront donc de moins en moins utiles à la communauté 
et présentent surtout un caractère historique.

Ces problèmes sont également abordés, avec des exemples pratiques, 
dans l'extension <ctanpkg:testflow> de Mike Shell, vu ici comme un 
[tutoriel spécialisé](/1_generalites/documentation/documents/tutoriels/tutoriaux).


:::{sources}
[Quality of PDF from PostScript](faquk:FAQ-dvips-pdf)
:::