---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index
---

# Comment changer le style d'un numéro de page de référence ?

La syntaxe pour un tel besoin est la suivante :

```{noedit}
\index{Sport|textbf}
```

Une telle entrée dans l'index verra son numéro de page mis en gras. 
Bien entendu, n'importe quelle commande peut être utilisée ici, à condition :

- qu'elle prenne un seul argument ;
- et que la contre-oblique initiale `\` de la commande soit supprimée.

En voici un exemple d'application, illustrant par la même occasion 
comment utiliser cette fonctionnalité avec la structure hiérarchique 
d'index évoquée à la question 
"[](/3_composition/annexes/index/construire_un_index_hierarchique)".

```
%!TEX makeindex document
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{makeidx}

  \makeindex

\begin{document}
\section{Légumes oubliés}
Ces légumes\index{Légumes|textbf} autrefois délaissés reviennent en force. 
Du rutabaga\index{Légumes!Rutabaga|textit} au cerfeuil 
tubéreux\index{Légumes!Cerfeuil tubéreux|textit}, redécouvrons ici 
ces légumes injustement traités.

\printindex
\end{document}
```


:::{sources}
- [Documentation] de <ctanpkg:makeidx>
:::