---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              légende, flottant, problème de légende, où mettre la légende
---

# Que signifie l'erreur : "`\caption` outside float" ?

- **Message** : `\caption outside float`
- **Origine** : LaTeX

Une commande `\caption` a été trouvée en dehors d'un environnement de flottant
tel que `figure` ou `table`. 

Si vous avez cherché à placer des figures côte à côte avec une légende commune, 
vous pouvez consulter la question 
"[](/3_composition/flottants/positionnement/placer_des_figures_cote_a_cote)" qui
évoque l'extension <ctanpkg:subcaption>. Vous pouvez également consulter 
la section 6 du *LaTeX Companion*.


:::{sources}
- [Problème : \caption outside float. \caption](https://texnique.fr/osqa/questions/8090/probleme-caption-outside-float-caption),
  sur [TeXnique.fr](https://texnique.fr/)
- [Resolving caption outside float error message](https://latex.org/forum/viewtopic.php?t=35772),
  sur [LaTeX.org](https://latex.org/)
- [FAQ erreurs - Lettre C](https://latex.developpez.com/faq/erreurs?page=C), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::