; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86,X86-SSE
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX1OR2,X86-AVX1
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX1OR2,X86-AVX2
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX512,X86-AVX512VL
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16,+avx512vl | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX512,X86-AVX512FP16
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX512,X86-AVX512VLDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X64,X64-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX1OR2,X64-AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX1OR2,X64-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX512,X64-AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16,+avx512vl | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX512,X64-AVX512FP16
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX512,X64-AVX512VLDQ

;
; 128-bit Vectors
;

define <2 x double> @fabs_v2f64(<2 x double> %p) nounwind {
; X86-SSE-LABEL: fabs_v2f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1OR2-LABEL: fabs_v2f64:
; X86-AVX1OR2:       # %bb.0:
; X86-AVX1OR2-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1OR2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v2f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v2f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v2f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v2f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1OR2-LABEL: fabs_v2f64:
; X64-AVX1OR2:       # %bb.0:
; X64-AVX1OR2-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX1OR2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v2f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v2f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v2f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <2 x double> @llvm.fabs.v2f64(<2 x double> %p)
  ret <2 x double> %t
}
declare <2 x double> @llvm.fabs.v2f64(<2 x double> %p)

define <4 x float> @fabs_v4f32(<4 x float> %p) nounwind {
; X86-SSE-LABEL: fabs_v4f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v4f32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v4f32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vandps %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v4f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v4f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v4f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v4f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v4f32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v4f32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vandps %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v4f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v4f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v4f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <4 x float> @llvm.fabs.v4f32(<4 x float> %p)
  ret <4 x float> %t
}
declare <4 x float> @llvm.fabs.v4f32(<4 x float> %p)

define <8 x half> @fabs_v8f16(ptr %p) nounwind {
; X86-SSE-LABEL: fabs_v8f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v8f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovaps (%eax), %xmm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v8f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vpand (%eax), %xmm0, %xmm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512-LABEL: fabs_v8f16:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX512-NEXT:    vpand (%eax), %xmm0, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v8f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v8f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v8f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vpand (%rdi), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: fabs_v8f16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX512-NEXT:    vpand (%rdi), %xmm0, %xmm0
; X64-AVX512-NEXT:    retq
  %v = load <8 x half>, ptr %p, align 16
  %nnv = call <8 x half> @llvm.fabs.v8f16(<8 x half> %v)
  ret <8 x half> %nnv
}
declare <8 x half> @llvm.fabs.v8f16(<8 x half> %p)

;
; 256-bit Vectors
;

define <4 x double> @fabs_v4f64(<4 x double> %p) nounwind {
; X86-SSE-LABEL: fabs_v4f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN]
; X86-SSE-NEXT:    andps %xmm2, %xmm0
; X86-SSE-NEXT:    andps %xmm2, %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v4f64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v4f64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vandps %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v4f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v4f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v4f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v4f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN]
; X64-SSE-NEXT:    andps %xmm2, %xmm0
; X64-SSE-NEXT:    andps %xmm2, %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v4f64:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v4f64:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vandps %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v4f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v4f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v4f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <4 x double> @llvm.fabs.v4f64(<4 x double> %p)
  ret <4 x double> %t
}
declare <4 x double> @llvm.fabs.v4f64(<4 x double> %p)

define <8 x float> @fabs_v8f32(<8 x float> %p) nounwind {
; X86-SSE-LABEL: fabs_v8f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN,NaN,NaN]
; X86-SSE-NEXT:    andps %xmm2, %xmm0
; X86-SSE-NEXT:    andps %xmm2, %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v8f32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v8f32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vandps %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v8f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v8f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v8f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v8f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN,NaN,NaN]
; X64-SSE-NEXT:    andps %xmm2, %xmm0
; X64-SSE-NEXT:    andps %xmm2, %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v8f32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v8f32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vandps %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v8f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v8f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v8f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <8 x float> @llvm.fabs.v8f32(<8 x float> %p)
  ret <8 x float> %t
}
declare <8 x float> @llvm.fabs.v8f32(<8 x float> %p)

define <16 x half> @fabs_v16f16(ptr %p) nounwind {
; X86-SSE-LABEL: fabs_v16f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps {{.*#+}} xmm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    andps %xmm1, %xmm0
; X86-SSE-NEXT:    andps 16(%eax), %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v16f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovaps (%eax), %ymm0
; X86-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v16f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vpand (%eax), %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512-LABEL: fabs_v16f16:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX512-NEXT:    vpand (%eax), %ymm0, %ymm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v16f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    andps %xmm1, %xmm0
; X64-SSE-NEXT:    andps 16(%rdi), %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v16f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v16f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vpand (%rdi), %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: fabs_v16f16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX512-NEXT:    vpand (%rdi), %ymm0, %ymm0
; X64-AVX512-NEXT:    retq
  %v = load <16 x half>, ptr %p, align 32
  %nnv = call <16 x half> @llvm.fabs.v16f16(<16 x half> %v)
  ret <16 x half> %nnv
}
declare <16 x half> @llvm.fabs.v16f16(<16 x half> %p)

;
; 512-bit Vectors
;

define <8 x double> @fabs_v8f64(<8 x double> %p) nounwind {
; X86-SSE-LABEL: fabs_v8f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-16, %esp
; X86-SSE-NEXT:    subl $16, %esp
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [NaN,NaN]
; X86-SSE-NEXT:    andps %xmm3, %xmm0
; X86-SSE-NEXT:    andps %xmm3, %xmm1
; X86-SSE-NEXT:    andps %xmm3, %xmm2
; X86-SSE-NEXT:    andps 8(%ebp), %xmm3
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
;
; X86-AVX1OR2-LABEL: fabs_v8f64:
; X86-AVX1OR2:       # %bb.0:
; X86-AVX1OR2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN]
; X86-AVX1OR2-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X86-AVX1OR2-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X86-AVX1OR2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v8f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v8f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v8f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v8f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm4 = [NaN,NaN]
; X64-SSE-NEXT:    andps %xmm4, %xmm0
; X64-SSE-NEXT:    andps %xmm4, %xmm1
; X64-SSE-NEXT:    andps %xmm4, %xmm2
; X64-SSE-NEXT:    andps %xmm4, %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX1OR2-LABEL: fabs_v8f64:
; X64-AVX1OR2:       # %bb.0:
; X64-AVX1OR2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN]
; X64-AVX1OR2-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X64-AVX1OR2-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X64-AVX1OR2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v8f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v8f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v8f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <8 x double> @llvm.fabs.v8f64(<8 x double> %p)
  ret <8 x double> %t
}
declare <8 x double> @llvm.fabs.v8f64(<8 x double> %p)

define <16 x float> @fabs_v16f32(<16 x float> %p) nounwind {
; X86-SSE-LABEL: fabs_v16f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-16, %esp
; X86-SSE-NEXT:    subl $16, %esp
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [NaN,NaN,NaN,NaN]
; X86-SSE-NEXT:    andps %xmm3, %xmm0
; X86-SSE-NEXT:    andps %xmm3, %xmm1
; X86-SSE-NEXT:    andps %xmm3, %xmm2
; X86-SSE-NEXT:    andps 8(%ebp), %xmm3
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
;
; X86-AVX1OR2-LABEL: fabs_v16f32:
; X86-AVX1OR2:       # %bb.0:
; X86-AVX1OR2-NEXT:    vbroadcastss {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX1OR2-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X86-AVX1OR2-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X86-AVX1OR2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v16f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v16f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v16f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v16f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm4 = [NaN,NaN,NaN,NaN]
; X64-SSE-NEXT:    andps %xmm4, %xmm0
; X64-SSE-NEXT:    andps %xmm4, %xmm1
; X64-SSE-NEXT:    andps %xmm4, %xmm2
; X64-SSE-NEXT:    andps %xmm4, %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX1OR2-LABEL: fabs_v16f32:
; X64-AVX1OR2:       # %bb.0:
; X64-AVX1OR2-NEXT:    vbroadcastss {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX1OR2-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X64-AVX1OR2-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X64-AVX1OR2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v16f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v16f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v16f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <16 x float> @llvm.fabs.v16f32(<16 x float> %p)
  ret <16 x float> %t
}
declare <16 x float> @llvm.fabs.v16f32(<16 x float> %p)

define <32 x half> @fabs_v32f16(ptr %p) nounwind {
; X86-SSE-LABEL: fabs_v32f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    andps %xmm3, %xmm0
; X86-SSE-NEXT:    movaps 16(%eax), %xmm1
; X86-SSE-NEXT:    andps %xmm3, %xmm1
; X86-SSE-NEXT:    movaps 32(%eax), %xmm2
; X86-SSE-NEXT:    andps %xmm3, %xmm2
; X86-SSE-NEXT:    andps 48(%eax), %xmm3
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fabs_v32f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX1-NEXT:    vandps (%eax), %ymm1, %ymm0
; X86-AVX1-NEXT:    vandps 32(%eax), %ymm1, %ymm1
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fabs_v32f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX2-NEXT:    vpand (%eax), %ymm1, %ymm0
; X86-AVX2-NEXT:    vpand 32(%eax), %ymm1, %ymm1
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v32f16:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512VL-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    vpandq (%eax), %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fabs_v32f16:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512FP16-NEXT:    vpbroadcastw {{.*#+}} zmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX512FP16-NEXT:    vpandq (%eax), %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v32f16:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512VLDQ-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX512VLDQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    vpandq (%eax), %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fabs_v32f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm3 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    andps %xmm3, %xmm0
; X64-SSE-NEXT:    movaps 16(%rdi), %xmm1
; X64-SSE-NEXT:    andps %xmm3, %xmm1
; X64-SSE-NEXT:    movaps 32(%rdi), %xmm2
; X64-SSE-NEXT:    andps %xmm3, %xmm2
; X64-SSE-NEXT:    andps 48(%rdi), %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fabs_v32f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX1-NEXT:    vandps (%rdi), %ymm1, %ymm0
; X64-AVX1-NEXT:    vandps 32(%rdi), %ymm1, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fabs_v32f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX2-NEXT:    vpand (%rdi), %ymm1, %ymm0
; X64-AVX2-NEXT:    vpand 32(%rdi), %ymm1, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v32f16:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    vpandq (%rdi), %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fabs_v32f16:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpbroadcastw {{.*#+}} zmm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX512FP16-NEXT:    vpandq (%rdi), %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v32f16:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX512VLDQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    vpandq (%rdi), %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %v = load <32 x half>, ptr %p, align 64
  %nnv = call <32 x half> @llvm.fabs.v32f16(<32 x half> %v)
  ret <32 x half> %nnv
}
declare <32 x half> @llvm.fabs.v32f16(<32 x half> %p)

; PR20354: when generating code for a vector fabs op,
; make sure that we're only turning off the sign bit of each float value.
; No constant pool loads or vector ops are needed for the fabs of a
; bitcasted integer constant; we should just return an integer constant
; that has the sign bits turned off.
;
; So instead of something like this:
;    movabsq (constant pool load of mask for sign bits)
;    vmovq   (move from integer register to vector/fp register)
;    vandps  (mask off sign bits)
;    vmovq   (move vector/fp register back to integer return register)
;
; We should generate:
;    mov     (put constant value in return register)

define i64 @fabs_v2f32_1() nounwind {
; X86-LABEL: fabs_v2f32_1:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    movl $2147483647, %edx # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: fabs_v2f32_1:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $9223372032559808512, %rax # imm = 0x7FFFFFFF00000000
; X64-NEXT:    retq
 %bitcast = bitcast i64 18446744069414584320 to <2 x float> ; 0xFFFF_FFFF_0000_0000
 %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %bitcast)
 %ret = bitcast <2 x float> %fabs to i64
 ret i64 %ret
}

define i64 @fabs_v2f32_2() nounwind {
; X86-LABEL: fabs_v2f32_2:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: fabs_v2f32_2:
; X64:       # %bb.0:
; X64-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
 %bitcast = bitcast i64 4294967295 to <2 x float> ; 0x0000_0000_FFFF_FFFF
 %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %bitcast)
 %ret = bitcast <2 x float> %fabs to i64
 ret i64 %ret
}

declare <2 x float> @llvm.fabs.v2f32(<2 x float> %p)

; PR70947 - remove duplicate xmm/ymm constant loads
define void @PR70947(ptr %src, ptr %dst) nounwind {
; X86-SSE-LABEL: PR70947:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE-NEXT:    movups (%ecx), %xmm0
; X86-SSE-NEXT:    movups 32(%ecx), %xmm1
; X86-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN]
; X86-SSE-NEXT:    andps %xmm2, %xmm0
; X86-SSE-NEXT:    andps %xmm2, %xmm1
; X86-SSE-NEXT:    movups %xmm0, (%eax)
; X86-SSE-NEXT:    movups %xmm1, 16(%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: PR70947:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-AVX-NEXT:    vbroadcastsd {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN]
; X86-AVX-NEXT:    vandps (%ecx), %ymm0, %ymm1
; X86-AVX-NEXT:    vandps 32(%ecx), %xmm0, %xmm0
; X86-AVX-NEXT:    vmovups %ymm1, (%eax)
; X86-AVX-NEXT:    vmovups %xmm0, 16(%eax)
; X86-AVX-NEXT:    vzeroupper
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: PR70947:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movups (%rdi), %xmm0
; X64-SSE-NEXT:    movups 32(%rdi), %xmm1
; X64-SSE-NEXT:    movaps {{.*#+}} xmm2 = [NaN,NaN]
; X64-SSE-NEXT:    andps %xmm2, %xmm0
; X64-SSE-NEXT:    andps %xmm2, %xmm1
; X64-SSE-NEXT:    movups %xmm0, (%rsi)
; X64-SSE-NEXT:    movups %xmm1, 16(%rsi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: PR70947:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastsd {{.*#+}} ymm0 = [NaN,NaN,NaN,NaN]
; X64-AVX-NEXT:    vandps (%rdi), %ymm0, %ymm1
; X64-AVX-NEXT:    vandps 32(%rdi), %xmm0, %xmm0
; X64-AVX-NEXT:    vmovups %ymm1, (%rsi)
; X64-AVX-NEXT:    vmovups %xmm0, 16(%rsi)
; X64-AVX-NEXT:    vzeroupper
; X64-AVX-NEXT:    retq
  %src4 = getelementptr inbounds double, ptr %src, i64 4
  %dst4 = getelementptr inbounds i32, ptr %dst, i64 4
  %ld0 = load <4 x double>, ptr %src, align 8
  %ld4 = load <2 x double>, ptr %src4, align 8
  %fabs0 = tail call <4 x double> @llvm.fabs.v4f64(<4 x double> %ld0)
  %fabs4 = tail call <2 x double> @llvm.fabs.v2f64(<2 x double> %ld4)
  store <4 x double> %fabs0, ptr %dst, align 4
  store <2 x double> %fabs4, ptr %dst4, align 4
  ret void
}
