; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test 128-bit funnel shifts.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z15 | FileCheck %s --check-prefix=Z15

declare i128 @llvm.fshl.i128(i128, i128, i128)
declare i128 @llvm.fshr.i128(i128, i128, i128)

; Funnel shift left by constant multiple of 8.
define i128 @f1(i128 %a, i128 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vsldb %v0, %v1, %v0, 4
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f1:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsldb %v0, %v1, %v0, 4
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshl.i128(i128 %a, i128 %b, i128 32)
  ret i128 %res
}

; Funnel shift left by constant smaller than 8.
define i128 @f2(i128 %a, i128 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vrepib %v2, 5
; CHECK-NEXT:    vsl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 123
; CHECK-NEXT:    vsrlb %v0, %v0, %v2
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f2:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsld %v0, %v1, %v0, 5
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshl.i128(i128 %a, i128 %b, i128 5)
  ret i128 %res
}

; Funnel shift left by some other constant.
define i128 @f3(i128 %a, i128 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vrepib %v2, 86
; CHECK-NEXT:    vsrlb %v1, %v1, %v2
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vsrl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 42
; CHECK-NEXT:    vslb %v0, %v0, %v2
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f3:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsldb %v1, %v1, %v0, 5
; Z15-NEXT:    vsldb %v0, %v0, %v0, 5
; Z15-NEXT:    vsld %v0, %v1, %v0, 2
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshl.i128(i128 %a, i128 %b, i128 42)
  ret i128 %res
}

; Funnel shift left by a variable amount.
define i128 @f4(i128 %a, i128 %b, i128 %sh) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r5)
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vslb %v1, %v1, %v2
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vsl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 1
; CHECK-NEXT:    xilf %r0, 4294967295
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v2
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f4:
; Z15:       # %bb.0:
; Z15-NEXT:    l %r0, 12(%r5)
; Z15-NEXT:    vlvgp %v2, %r0, %r0
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vrepb %v2, %v2, 15
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vslb %v1, %v1, %v2
; Z15-NEXT:    vsl %v1, %v1, %v2
; Z15-NEXT:    vrepib %v2, 1
; Z15-NEXT:    xilf %r0, 4294967295
; Z15-NEXT:    vsrl %v0, %v0, %v2
; Z15-NEXT:    vlvgp %v2, %r0, %r0
; Z15-NEXT:    vrepb %v2, %v2, 15
; Z15-NEXT:    vsrlb %v0, %v0, %v2
; Z15-NEXT:    vsrl %v0, %v0, %v2
; Z15-NEXT:    vo %v0, %v1, %v0
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshl.i128(i128 %a, i128 %b, i128 %sh)
  ret i128 %res
}

; Funnel shift right by constant multiple of 8.
define i128 @f5(i128 %a, i128 %b) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vsldb %v0, %v1, %v0, 12
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f5:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsldb %v0, %v1, %v0, 12
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshr.i128(i128 %a, i128 %b, i128 32)
  ret i128 %res
}

; Funnel shift right by constant smaller than 8.
define i128 @f6(i128 %a, i128 %b) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepib %v2, 5
; CHECK-NEXT:    vsrl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 123
; CHECK-NEXT:    vslb %v0, %v0, %v2
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f6:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsrd %v0, %v1, %v0, 5
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshr.i128(i128 %a, i128 %b, i128 5)
  ret i128 %res
}

; Funnel shift right by some other constant.
define i128 @f7(i128 %a, i128 %b) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vrepib %v2, 42
; CHECK-NEXT:    vsrlb %v1, %v1, %v2
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vsrl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 86
; CHECK-NEXT:    vslb %v0, %v0, %v2
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f7:
; Z15:       # %bb.0:
; Z15-NEXT:    vl %v0, 0(%r4), 3
; Z15-NEXT:    vl %v1, 0(%r3), 3
; Z15-NEXT:    vsldb %v0, %v1, %v0, 11
; Z15-NEXT:    vsldb %v1, %v1, %v1, 11
; Z15-NEXT:    vsrd %v0, %v1, %v0, 2
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshr.i128(i128 %a, i128 %b, i128 42)
  ret i128 %res
}

; Funnel shift right by a variable amount.
define i128 @f8(i128 %a, i128 %b, i128 %sh) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r5)
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vsrlb %v1, %v1, %v2
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vsrl %v1, %v1, %v2
; CHECK-NEXT:    vrepib %v2, 1
; CHECK-NEXT:    xilf %r0, 4294967295
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vslb %v0, %v0, %v2
; CHECK-NEXT:    vsl %v0, %v0, %v2
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
;
; Z15-LABEL: f8:
; Z15:       # %bb.0:
; Z15-NEXT:    l %r0, 12(%r5)
; Z15-NEXT:    vlvgp %v2, %r0, %r0
; Z15-NEXT:    vl %v1, 0(%r4), 3
; Z15-NEXT:    vrepb %v2, %v2, 15
; Z15-NEXT:    vl %v0, 0(%r3), 3
; Z15-NEXT:    vsrlb %v1, %v1, %v2
; Z15-NEXT:    vsrl %v1, %v1, %v2
; Z15-NEXT:    vrepib %v2, 1
; Z15-NEXT:    xilf %r0, 4294967295
; Z15-NEXT:    vsl %v0, %v0, %v2
; Z15-NEXT:    vlvgp %v2, %r0, %r0
; Z15-NEXT:    vrepb %v2, %v2, 15
; Z15-NEXT:    vslb %v0, %v0, %v2
; Z15-NEXT:    vsl %v0, %v0, %v2
; Z15-NEXT:    vo %v0, %v0, %v1
; Z15-NEXT:    vst %v0, 0(%r2), 3
; Z15-NEXT:    br %r14
  %res = tail call i128 @llvm.fshr.i128(i128 %a, i128 %b, i128 %sh)
  ret i128 %res
}

