/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimprasterizable_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimprasterizable
 * @title: gimprasterizable
 * @short_description: Functions for querying and manipulating rasterizable items.
 *
 * Functions for querying and manipulating rasterizable items.
 **/


/**
 * gimp_rasterizable_rasterize:
 * @item: The rasterizable item.
 *
 * Rasterize the object.
 *
 * This procedure makes the item behave like a typical raster layer.
 *
 * Note that the source information (text contents and properties for a
 * text layer, source file for a link layer, path and render properties
 * for a vector layer, etc.) are not actually discarded, and it is
 * possible to retrieve the original behavior with
 * [method@Gimp.Rasterizable.restore].
 *
 * Returns: TRUE on success.
 *
 * Since: 3.2
 **/
gboolean
gimp_rasterizable_rasterize (GimpRasterizable *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_RASTERIZABLE, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-rasterizable-rasterize",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_rasterizable_restore:
 * @item: The rasterizable item.
 *
 * Revert the rasterization of @item.
 *
 * Restore the information making the item non-destructive, such as
 * text contents and properties of a text layer, source file of a link
 * layer, path and render properties of a vector layer, etc.
 * This item won't behave anymore like a raster item. In particular, it
 * will prevent direct modification of its pixels and will be rendered
 * when its properties are updated.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.2
 **/
gboolean
gimp_rasterizable_restore (GimpRasterizable *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_RASTERIZABLE, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-rasterizable-restore",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_rasterizable_is_rasterized:
 * @item: The rasterizable item.
 *
 * Return whether @item has been rasterized.
 *
 * This procedure returns %TRUE if the specified @item has been
 * previously rasterized. In this case, you should treat this @item as
 * the generic raster variant.
 *
 * For instance, a [class@Gimp.TextLayer] object implements the
 * %GimpRasterizable interface. If a text layer instance were to return
 * %TRUE, you should only consider its rendering as returned by
 * [method@Gimp.Drawable.get_buffer].
 *
 * On the other hand, if this returned %FALSE, depending on your
 * intents, you may prefer to use the text contents and its properties
 * with the various procedures provided by the [class@Gimp.TextLayer]
 * class interface.
 *
 * Returns: TRUE if @item is rasterized.
 *
 * Since: 3.2
 **/
gboolean
gimp_rasterizable_is_rasterized (GimpRasterizable *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean is_rasterized = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_RASTERIZABLE, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-rasterizable-is-rasterized",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    is_rasterized = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return is_rasterized;
}
