/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class DriverDescriptorEntry {
    private final byte[] ddBlock = new byte[4];
    private final byte[] ddSize = new byte[2];
    private final byte[] ddType = new byte[2];

    public DriverDescriptorEntry(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.ddBlock, 0, 4);
        System.arraycopy(data, offset + 4, this.ddSize, 0, 2);
        System.arraycopy(data, offset + 6, this.ddType, 0, 2);
    }

    public static int length() {
        return 8;
    }

    public int getDdBlock() {
        return Util.readIntBE(this.ddBlock);
    }

    public short getDdSize() {
        return Util.readShortBE(this.ddSize);
    }

    public short getDdType() {
        return Util.readShortBE(this.ddType);
    }

    public byte[] getData() {
        byte[] result = new byte[DriverDescriptorEntry.length()];
        int offset = 0;
        System.arraycopy(this.ddBlock, 0, result, offset, this.ddBlock.length);
        System.arraycopy(this.ddSize, 0, result, offset += this.ddBlock.length, this.ddSize.length);
        System.arraycopy(this.ddType, 0, result, offset += this.ddSize.length, this.ddType.length);
        if ((offset += this.ddType.length) != DriverDescriptorEntry.length()) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " ddBlock: " + this.getDdBlock());
        ps.println(prefix + " ddSize: " + this.getDdSize());
        ps.println(prefix + " ddType: " + this.getDdType());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "DriverDescriptorEntry:");
        this.printFields(ps, prefix);
    }
}

