/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import java.util.Hashtable;
import java.util.LinkedList;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.csjc.structelements.ByteArrayField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.EncodedStringField;
import org.catacombae.csjc.structelements.Endianness;
import org.catacombae.csjc.structelements.FlagField;
import org.catacombae.csjc.structelements.IntegerField;
import org.catacombae.csjc.structelements.IntegerFieldBits;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.csjc.structelements.Signedness;
import org.catacombae.csjc.structelements.StructElement;

public class DictionaryBuilder {
    private final String typeName;
    private final String typeDescription;
    private final LinkedList<String> keys = new LinkedList();
    private final Hashtable<String, StructElement> mappings = new Hashtable();
    private final Hashtable<String, String> descriptions = new Hashtable();

    public DictionaryBuilder(String typeName) {
        this(typeName, null);
    }

    public DictionaryBuilder(String typeName, String typeDescription) {
        this.typeName = typeName;
        this.typeDescription = typeDescription;
    }

    public void addIntArray(String key, byte[] data, IntegerFieldBits bits, Signedness signedness, Endianness endianness) {
        this.addIntArray(key, data, 0, data.length, bits, signedness, endianness);
    }

    public void addIntArray(String key, byte[] data, IntegerFieldBits bits, Signedness signedness, Endianness endianness, String description, IntegerFieldRepresentation rep) {
        this.addIntArray(key, data, 0, data.length, bits, signedness, endianness, description, rep);
    }

    public void addIntArray(String key, byte[] data, int offset, int length, IntegerFieldBits bits, Signedness signedness, Endianness endianness) {
        this.addIntArray(key, data, offset, length, bits, signedness, endianness, null, IntegerFieldRepresentation.DECIMAL);
    }

    public void addIntArray(String key, byte[] data, int offset, int length, IntegerFieldBits bits, Signedness signedness, Endianness endianness, String description, IntegerFieldRepresentation rep) {
        String arrayTypeName;
        if (length % bits.getBytes() != 0) {
            throw new RuntimeException("Supplied data is not aligned to size of type.");
        }
        switch (signedness) {
            case SIGNED: {
                arrayTypeName = "S";
                break;
            }
            case UNSIGNED: {
                arrayTypeName = "U";
                break;
            }
            default: {
                throw new IllegalArgumentException("signedness == null!");
            }
        }
        arrayTypeName = arrayTypeName + "Int" + bits.getBits() + "[" + length / bits.getBytes() + "]";
        ArrayBuilder ab = new ArrayBuilder(arrayTypeName);
        for (int i = 0; i < length; i += bits.getBytes()) {
            ab.add(new IntegerField(data, offset + i, bits, signedness, endianness, rep, null));
        }
        this.add(key, ab.getResult(), description);
    }

    public Dictionary getResult() {
        return new Dictionary(this.typeName, this.typeDescription, this.keys.toArray(new String[this.keys.size()]), this.mappings, this.descriptions);
    }

    public void add(String key, StructElement mapping) {
        this.add(key, mapping, null);
    }

    public void add(String key, StructElement mapping, String description) {
        if (this.mappings.get(key) != null) {
            throw new IllegalArgumentException("A mapping already exists for key \"" + key + "\"!");
        }
        this.mappings.put(key, mapping);
        if (description != null) {
            this.descriptions.put(key, description);
        }
        this.keys.add(key);
    }

    public void addSIntBE(String key, byte[] data) {
        this.addSIntBE(key, data, null);
    }

    public void addSIntLE(String key, byte[] data) {
        this.addSIntLE(key, data, null);
    }

    public void addUIntBE(String key, byte[] data) {
        this.addUIntBE(key, data, null);
    }

    public void addUIntLE(String key, byte[] data) {
        this.addUIntLE(key, data, null);
    }

    public void addSIntBE(String key, byte[] data, String description) {
        this.addSIntBE(key, data, 0, data.length, description, null, IntegerFieldRepresentation.DECIMAL);
    }

    public void addSIntLE(String key, byte[] data, String description) {
        this.addSIntLE(key, data, 0, data.length, description, null, IntegerFieldRepresentation.DECIMAL);
    }

    public void addUIntBE(String key, byte[] data, String description) {
        this.addUIntBE(key, data, 0, data.length, description, null, IntegerFieldRepresentation.DECIMAL);
    }

    public void addUIntLE(String key, byte[] data, String description) {
        this.addUIntLE(key, data, 0, data.length, description, null, IntegerFieldRepresentation.DECIMAL);
    }

    public void addSIntBE(String key, byte[] data, String description, String unit) {
        this.addSIntBE(key, data, 0, data.length, description, unit, IntegerFieldRepresentation.DECIMAL);
    }

    public void addSIntLE(String key, byte[] data, String description, String unit) {
        this.addSIntLE(key, data, 0, data.length, description, unit, IntegerFieldRepresentation.DECIMAL);
    }

    public void addUIntBE(String key, byte[] data, String description, String unit) {
        this.addUIntBE(key, data, 0, data.length, description, unit, IntegerFieldRepresentation.DECIMAL);
    }

    public void addUIntLE(String key, byte[] data, String description, String unit) {
        this.addUIntLE(key, data, 0, data.length, description, unit, IntegerFieldRepresentation.DECIMAL);
    }

    public void addSIntBE(String key, byte[] data, String description, IntegerFieldRepresentation rep) {
        this.addSIntBE(key, data, 0, data.length, description, null, rep);
    }

    public void addSIntLE(String key, byte[] data, String description, IntegerFieldRepresentation rep) {
        this.addSIntLE(key, data, 0, data.length, description, null, rep);
    }

    public void addUIntBE(String key, byte[] data, String description, IntegerFieldRepresentation rep) {
        this.addUIntBE(key, data, 0, data.length, description, null, rep);
    }

    public void addUIntLE(String key, byte[] data, String description, IntegerFieldRepresentation rep) {
        this.addUIntLE(key, data, 0, data.length, description, null, rep);
    }

    public void addSIntBE(String key, byte[] data, int offset, int length, String description, String unit, IntegerFieldRepresentation rep) {
        this.addInt(key, data, offset, length, Signedness.SIGNED, Endianness.BIG_ENDIAN, description, unit, rep);
    }

    public void addSIntLE(String key, byte[] data, int offset, int length, String description, String unit, IntegerFieldRepresentation rep) {
        this.addInt(key, data, offset, length, Signedness.SIGNED, Endianness.LITTLE_ENDIAN, description, unit, rep);
    }

    public void addUIntBE(String key, byte[] data, int offset, int length, String description, String unit, IntegerFieldRepresentation rep) {
        this.addInt(key, data, offset, length, Signedness.UNSIGNED, Endianness.BIG_ENDIAN, description, unit, rep);
    }

    public void addUIntLE(String key, byte[] data, int offset, int length, String description, String unit, IntegerFieldRepresentation rep) {
        this.addInt(key, data, offset, length, Signedness.UNSIGNED, Endianness.LITTLE_ENDIAN, description, unit, rep);
    }

    private void addInt(String key, byte[] data, int offset, int length, Signedness signedness, Endianness endianness, String description, String unit, IntegerFieldRepresentation rep) {
        switch (length) {
            case 1: {
                this.add(key, new IntegerField(data, offset, IntegerFieldBits.BITS_8, signedness, endianness, rep, unit), description);
                break;
            }
            case 2: {
                this.add(key, new IntegerField(data, offset, IntegerFieldBits.BITS_16, signedness, endianness, rep, unit), description);
                break;
            }
            case 4: {
                this.add(key, new IntegerField(data, offset, IntegerFieldBits.BITS_32, signedness, endianness, rep, unit), description);
                break;
            }
            case 8: {
                this.add(key, new IntegerField(data, offset, IntegerFieldBits.BITS_64, signedness, endianness, rep, unit), description);
                break;
            }
            default: {
                throw new IllegalArgumentException("You supplied a " + length * 8 + "-bit value. Only 64, 32, 16 and 8-bit values are supported.");
            }
        }
    }

    public void addByteArray(String key, byte[] data) {
        this.addByteArray(key, data, 0, data.length);
    }

    public void addByteArray(String key, byte[] data, int offset, int length) {
        this.addByteArray(key, data, offset, length, null);
    }

    public void addByteArray(String key, byte[] data, int offset, int length, String description) {
        this.add(key, new ByteArrayField(data, offset, length), description);
    }

    public void addFlag(String key, byte[] data, int bitOffset, String description) {
        this.addFlag(key, data, 0, data.length, bitOffset, description);
    }

    public void addFlag(String key, byte[] data, int bitOffset) {
        this.addFlag(key, data, 0, data.length, bitOffset);
    }

    public void addFlag(String key, byte[] data, int offset, int length, int bitOffset) {
        this.addFlag(key, data, offset, length, bitOffset, null);
    }

    public void addFlag(String key, byte[] data, int offset, int length, int bitOffset, String description) {
        this.add(key, new FlagField(data, offset, length, bitOffset), description);
    }

    public void addEncodedString(String key, byte[] data, String encoding) {
        this.addEncodedString(key, data, 0, data.length, encoding);
    }

    public void addEncodedString(String key, byte[] data, int offset, int length, String encoding) {
        this.add(key, new EncodedStringField(data, offset, length, encoding));
    }

    public void addAll(Dictionary d) {
        for (String key : d.getKeys()) {
            String description = d.getDescription(key);
            if (description != null) {
                this.add(key, d.getElement(key), description);
                continue;
            }
            this.add(key, d.getElement(key));
        }
    }
}

