// Copyright (c) 2026 Tigera, Inc. All rights reserved.

// Code generated by client-gen. DO NOT EDIT.

package v3

import (
	context "context"

	projectcalicov3 "github.com/projectcalico/api/pkg/apis/projectcalico/v3"
	scheme "github.com/projectcalico/api/pkg/client/clientset_generated/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// TiersGetter has a method to return a TierInterface.
// A group's client should implement this interface.
type TiersGetter interface {
	Tiers() TierInterface
}

// TierInterface has methods to work with Tier resources.
type TierInterface interface {
	Create(ctx context.Context, tier *projectcalicov3.Tier, opts v1.CreateOptions) (*projectcalicov3.Tier, error)
	Update(ctx context.Context, tier *projectcalicov3.Tier, opts v1.UpdateOptions) (*projectcalicov3.Tier, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*projectcalicov3.Tier, error)
	List(ctx context.Context, opts v1.ListOptions) (*projectcalicov3.TierList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *projectcalicov3.Tier, err error)
	TierExpansion
}

// tiers implements TierInterface
type tiers struct {
	*gentype.ClientWithList[*projectcalicov3.Tier, *projectcalicov3.TierList]
}

// newTiers returns a Tiers
func newTiers(c *ProjectcalicoV3Client) *tiers {
	return &tiers{
		gentype.NewClientWithList[*projectcalicov3.Tier, *projectcalicov3.TierList](
			"tiers",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *projectcalicov3.Tier { return &projectcalicov3.Tier{} },
			func() *projectcalicov3.TierList { return &projectcalicov3.TierList{} },
		),
	}
}
