// Copyright (c) 2026 Tigera, Inc. All rights reserved.

// Code generated by client-gen. DO NOT EDIT.

package v3

import (
	context "context"

	projectcalicov3 "github.com/projectcalico/api/pkg/apis/projectcalico/v3"
	scheme "github.com/projectcalico/api/pkg/client/clientset_generated/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// IPPoolsGetter has a method to return a IPPoolInterface.
// A group's client should implement this interface.
type IPPoolsGetter interface {
	IPPools() IPPoolInterface
}

// IPPoolInterface has methods to work with IPPool resources.
type IPPoolInterface interface {
	Create(ctx context.Context, iPPool *projectcalicov3.IPPool, opts v1.CreateOptions) (*projectcalicov3.IPPool, error)
	Update(ctx context.Context, iPPool *projectcalicov3.IPPool, opts v1.UpdateOptions) (*projectcalicov3.IPPool, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*projectcalicov3.IPPool, error)
	List(ctx context.Context, opts v1.ListOptions) (*projectcalicov3.IPPoolList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *projectcalicov3.IPPool, err error)
	IPPoolExpansion
}

// iPPools implements IPPoolInterface
type iPPools struct {
	*gentype.ClientWithList[*projectcalicov3.IPPool, *projectcalicov3.IPPoolList]
}

// newIPPools returns a IPPools
func newIPPools(c *ProjectcalicoV3Client) *iPPools {
	return &iPPools{
		gentype.NewClientWithList[*projectcalicov3.IPPool, *projectcalicov3.IPPoolList](
			"ippools",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *projectcalicov3.IPPool { return &projectcalicov3.IPPool{} },
			func() *projectcalicov3.IPPoolList { return &projectcalicov3.IPPoolList{} },
		),
	}
}
