static const struct dis386 evex_table[][256] = {
  /* EVEX_0F */
  {
    /* 00 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 08 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 10 */
    { PREFIX_TABLE (PREFIX_0F10) },
    { PREFIX_TABLE (PREFIX_0F11) },
    { PREFIX_TABLE (PREFIX_VEX_0F12) },
    { VEX_LEN_TABLE (VEX_LEN_0F13) },
    { "%XEvunpcklpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    { "%XEvunpckhpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    { PREFIX_TABLE (PREFIX_VEX_0F16) },
    { VEX_LEN_TABLE (VEX_LEN_0F17) },
    /* 18 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 20 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 28 */
    { "%XEvmovapX",	{ XM, EXx }, PREFIX_OPCODE },
    { "%XEvmovapX",	{ EXxS, XM }, PREFIX_OPCODE },
    { PREFIX_TABLE (PREFIX_VEX_0F2A) },
    { "%XEvmovntpX",	{ Mx, XM }, PREFIX_OPCODE },
    { PREFIX_TABLE (PREFIX_VEX_0F2C) },
    { PREFIX_TABLE (PREFIX_VEX_0F2D) },
    { PREFIX_TABLE (PREFIX_EVEX_0F2E) },
    { PREFIX_TABLE (PREFIX_EVEX_0F2F) },
    /* 30 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 38 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 40 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 48 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 50 */
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_0F51) },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvandpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    { "%XEvandnpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    { "%XEvorpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    { "%XEvxorpX",	{ XM, Vex, EXx }, PREFIX_OPCODE },
    /* 58 */
    { PREFIX_TABLE (PREFIX_0F58) },
    { PREFIX_TABLE (PREFIX_0F59) },
    { PREFIX_TABLE (PREFIX_0F5A) },
    { PREFIX_TABLE (PREFIX_EVEX_0F5B) },
    { PREFIX_TABLE (PREFIX_0F5C) },
    { PREFIX_TABLE (PREFIX_0F5D) },
    { PREFIX_TABLE (PREFIX_0F5E) },
    { PREFIX_TABLE (PREFIX_0F5F) },
    /* 60 */
    { "%XEvpunpcklbw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpunpcklwd",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F62) },
    { "%XEvpacksswb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpcmpgtb",	{ MaskG, Vex, EXx }, PREFIX_DATA },
    { "vpcmpgtw",	{ MaskG, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F66) },
    { "%XEvpackuswb",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* 68 */
    { "%XEvpunpckhbw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpunpckhwd",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F6A) },
    { VEX_W_TABLE (EVEX_W_0F6B) },
    { VEX_W_TABLE (EVEX_W_0F6C) },
    { VEX_W_TABLE (EVEX_W_0F6D) },
    { VEX_LEN_TABLE (VEX_LEN_0F6E) },
    { PREFIX_TABLE (PREFIX_EVEX_0F6F) },
    /* 70 */
    { PREFIX_TABLE (PREFIX_EVEX_0F70) },
    { REG_TABLE (REG_EVEX_0F71) },
    { REG_TABLE (REG_EVEX_0F72) },
    { REG_TABLE (REG_EVEX_0F73) },
    { "vpcmpeqb",	{ MaskG, Vex, EXx }, PREFIX_DATA },
    { "vpcmpeqw",	{ MaskG, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F76) },
    { Bad_Opcode },
    /* 78 */
    { PREFIX_TABLE (PREFIX_EVEX_0F78) },
    { PREFIX_TABLE (PREFIX_EVEX_0F79) },
    { PREFIX_TABLE (PREFIX_EVEX_0F7A) },
    { PREFIX_TABLE (PREFIX_EVEX_0F7B) },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_0F7E) },
    { PREFIX_TABLE (PREFIX_EVEX_0F7F) },
    /* 80 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 90 */
    { X86_64_EVEX_W_TABLE (VEX_W_0F90_L_0) },
    { X86_64_EVEX_W_TABLE (VEX_W_0F91_L_0) },
    { X86_64_EVEX_W_TABLE (VEX_W_0F92_L_0) },
    { X86_64_EVEX_W_TABLE (VEX_W_0F93_L_0) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 98 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_0FC2) },
    { Bad_Opcode },
    { VEX_LEN_TABLE (VEX_LEN_0FC4) },
    { "%XEvpextrw",	{ Gd, Uxmm, Ib }, PREFIX_DATA },
    { "%XEvshufpX",	{ XM, Vex, EXx, Ib }, PREFIX_OPCODE },
    { Bad_Opcode },
    /* C8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D0 */
    { Bad_Opcode },
    { "%XEvpsrlw",	{ XM, Vex, EXxmm }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FD2) },
    { VEX_W_TABLE (EVEX_W_0FD3) },
    { VEX_W_TABLE (EVEX_W_0FD4) },
    { "%XEvpmullw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FD6) },
    { Bad_Opcode },
    /* D8 */
    { "%XEvpsubusb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpsubusw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpminub",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpand%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpaddusb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpaddusw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxub",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpandn%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* E0 */
    { "%XEvpavgb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpsraw",	{ XM, Vex, EXxmm }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FE2) },
    { "%XEvpavgw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmulhuw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmulhw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0FE6) },
    { VEX_W_TABLE (EVEX_W_0FE7) },
    /* E8 */
    { "%XEvpsubsb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpsubsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpminsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpor%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpaddsb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpaddsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpxor%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* F0 */
    { Bad_Opcode },
    { "%XEvpsllw",	{ XM, Vex, EXxmm }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FF2) },
    { VEX_W_TABLE (EVEX_W_0FF3) },
    { VEX_W_TABLE (EVEX_W_0FF4) },
    { "%XEvpmaddwd",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpsadbwY",	{ XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    /* F8 */
    { "%XEvpsubb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpsubw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FFA) },
    { VEX_W_TABLE (EVEX_W_0FFB) },
    { "%XEvpaddb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpaddw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0FFE) },
    { Bad_Opcode },
  },
  /* EVEX_0F38 */
  {
    /* 00 */
    { "%XEvpshufb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvpmaddubsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 08 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvpmulhrsw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (VEX_W_0F380C) },
    { "%XEvpermilp%XD", { XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 10 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3810) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3811) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3812) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3813) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3814) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3815) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3816) },
    { Bad_Opcode },
    /* 18 */
    { VEX_W_TABLE (VEX_W_0F3818) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3819) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F381A) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F381B) },
    { "%XEvpabsb",		{ XM, EXx }, PREFIX_DATA },
    { "%XEvpabsw",		{ XM, EXx }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F381E) },
    { VEX_W_TABLE (EVEX_W_0F381F) },
    /* 20 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3820) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3821) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3822) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3823) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3824) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3825) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3826) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3827) },
    /* 28 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3828) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3829) },
    { PREFIX_TABLE (PREFIX_EVEX_0F382A) },
    { VEX_W_TABLE (EVEX_W_0F382B) },
    { "vscalefp%XW",	{ XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "vscalefs%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 30 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3830) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3831) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3832) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3833) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3834) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3835) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3836) },
    { VEX_W_TABLE (EVEX_W_0F3837) },
    /* 38 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3838) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3839) },
    { PREFIX_TABLE (PREFIX_EVEX_0F383A) },
    { "%XEvpminu%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxsb",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxs%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxuw",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvpmaxu%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* 40 */
    { "%XEvpmull%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { "vgetexpp%XW",	{ XM, EXx, EXxEVexS }, PREFIX_DATA },
    { "vgetexps%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexS }, PREFIX_DATA },
    { "vplzcnt%DQ",	{ XM, EXx }, PREFIX_DATA },
    { "vpsrlv%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpsrav%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpsllv%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* 48 */
    { Bad_Opcode },
    { X86_64_EVEX_MEM_W_TABLE (VEX_W_0F3849_X86_64_L_0) },
    { X86_64_TABLE (X86_64_EVEX_0F384A) },
    { X86_64_EVEX_MEM_W_TABLE (VEX_W_0F384B_X86_64_L_0) },
    { "vrcp14p%XW",	{ XM, EXx }, PREFIX_DATA },
    { "vrcp14s%XW",	{ XMScalar, VexScalar, EXdq }, PREFIX_DATA },
    { "vrsqrt14p%XW",	{ XM, EXx }, 0 },
    { "vrsqrt14s%XW",	{ XMScalar, VexScalar, EXdq }, PREFIX_DATA },
    /* 50 */
    { VEX_W_TABLE (VEX_W_0F3850) },
    { VEX_W_TABLE (VEX_W_0F3851) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3852) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3853) },
    { "vpopcnt%BW",	{ XM, EXx }, PREFIX_DATA },
    { "vpopcnt%DQ",	{ XM, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 58 */
    { VEX_W_TABLE (VEX_W_0F3858) },
    { VEX_W_TABLE (EVEX_W_0F3859) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F385A) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F385B) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 60 */
    { Bad_Opcode },
    { Bad_Opcode },
    { "vpexpand%BW",	{ XM, EXbwUnit }, PREFIX_DATA },
    { "vpcompress%BW",	{ EXbwUnit, XM }, PREFIX_DATA },
    { "vpblendm%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vblendmp%XW",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpblendm%BW",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vcvt2p%XS2phx",	{ XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    /* 68 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3868) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { X86_64_TABLE (X86_64_EVEX_0F386D) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F386E) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F386F) },
    /* 70 */
    { VEX_W_TABLE (EVEX_W_0F3870) },
    { "vpshldv%DQ",  { XM, Vex, EXx }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3872) },
    { "vpshrdv%DQ",  { XM, Vex, EXx }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3874) },
    { "vpermi2%BW",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpermi2%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpermi2p%XW",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* 78 */
    { VEX_W_TABLE (VEX_W_0F3878) },
    { VEX_W_TABLE (VEX_W_0F3879) },
    { VEX_W_TABLE (EVEX_W_0F387A) },
    { VEX_W_TABLE (EVEX_W_0F387B) },
    { "vpbroadcastK",	{ XM, Rdq }, PREFIX_DATA },
    { "vpermt2%BW",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpermt2%DQ",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "vpermt2p%XW",	{ XM, Vex, EXx }, PREFIX_DATA },
    /* 80 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (EVEX_W_0F3883) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { "vexpandp%XW",	{ XM, EXEvexXGscat }, PREFIX_DATA },
    { "vpexpand%DQ",	{ XM, EXEvexXGscat }, PREFIX_DATA },
    { "vcompressp%XW",	{ EXEvexXGscat, XM }, PREFIX_DATA },
    { "vpcompress%DQ",	{ EXEvexXGscat, XM }, PREFIX_DATA },
    { Bad_Opcode },
    { "vperm%BW",	{ XM, Vex, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { "vpshufbitqmb",	{ MaskG, Vex, EXx }, PREFIX_DATA },
    /* 90 */
    { "vpgatherd%DQ",	{ XMGatherD, MVexVSIBDWpX }, PREFIX_DATA },
    { "vpgatherq%DQ",	{ XMGatherQ, MVexVSIBQWpX }, PREFIX_DATA },
    { "vgatherdp%XW",	{ XMGatherD, MVexVSIBDWpX }, PREFIX_DATA },
    { "vgatherqp%XW",	{ XMGatherQ, MVexVSIBQWpX }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvfmaddsub132p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmsubadd132p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    /* 98 */
    { "%XEvfmadd132p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmadd132s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F389A) },
    { PREFIX_TABLE (PREFIX_EVEX_0F389B) },
    { "%XEvfnmadd132p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmadd132s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub132p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub132s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    /* A0 */
    { "vpscatterd%DQ",	{ MVexVSIBDWpX, XM }, PREFIX_DATA },
    { "vpscatterq%DQ",	{ MVexVSIBQWpX, XMGatherQ }, PREFIX_DATA },
    { "vscatterdp%XW",	{ MVexVSIBDWpX, XM }, PREFIX_DATA },
    { "vscatterqp%XW",	{ MVexVSIBQWpX, XMGatherQ }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvfmaddsub213p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmsubadd213p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    /* A8 */
    { "%XEvfmadd213p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmadd213s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F38AA) },
    { PREFIX_TABLE (PREFIX_EVEX_0F38AB) },
    { "%XEvfnmadd213p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmadd213s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub213p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub213s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F38B4) },
    { VEX_W_TABLE (VEX_W_0F38B5) },
    { "%XEvfmaddsub231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmsubadd231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    /* B8 */
    { "%XEvfmadd231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmadd231s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmsub231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfmsub231s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmadd231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmadd231s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub231p%XW", { XM, Vex, EXx, EXxEVexR }, PREFIX_DATA },
    { "%XEvfnmsub231s%XW", { XMScalar, VexScalar, EXdq, EXxEVexR }, PREFIX_DATA },
    /* C0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "vpconflict%DQ",	{ XM, EXx }, PREFIX_DATA },
    { Bad_Opcode },
    { EVEX_LEN_TABLE (EVEX_LEN_0F38C6) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F38C7) },
    /* C8 */
    { "vexp2p%XW",	{ XM, EXx, EXxEVexS }, PREFIX_DATA },
    { Bad_Opcode },
    { "vrcp28p%XW",	{ XM, EXx, EXxEVexS }, PREFIX_DATA },
    { "vrcp28s%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexS }, PREFIX_DATA },
    { "vrsqrt28p%XW",	{ XM, EXx, EXxEVexS }, PREFIX_DATA },
    { "vrsqrt28s%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexS }, PREFIX_DATA },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F38CF) },
    /* D0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F38D2) },
    { VEX_W_TABLE (VEX_W_0F38D3) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F38DA) },
    { Bad_Opcode },
    { "%XEvaesencY",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvaesenclastY", { XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvaesdecY",	{ XM, Vex, EXx }, PREFIX_DATA },
    { "%XEvaesdeclastY", { XM, Vex, EXx }, PREFIX_DATA },
    /* E0 */
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    /* E8 */
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_0F38Ex) },
    /* F0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F38F2_L_0) },
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F38F3_L_0) },
    { Bad_Opcode },
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F38F5_L_0) },
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F38F6_L_0) },
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F38F7_L_0) },
    /* F8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
  },
  /* EVEX_0F3A */
  {
    /* 00 */
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A00) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A01) },
    { Bad_Opcode },
    { "valign%DQ",	{ XM, Vex, EXx, Ib }, PREFIX_DATA },
    { VEX_W_TABLE (VEX_W_0F3A04) },
    { "%XEvpermilp%XD", { XM, EXx, Ib }, PREFIX_DATA },
    { Bad_Opcode },
    { X86_64_TABLE (X86_64_EVEX_0F3A07) },
    /* 08 */
    { PREFIX_TABLE (PREFIX_EVEX_0F3A08) },
    { "vrndscalep%XD", { XM, EXx, EXxEVexS, Ib }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A0A) },
    { "vrndscales%XD", { XMScalar, VexScalar, EXq, EXxEVexS, Ib }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%XEvpalignr",	{ XM, Vex, EXx, Ib }, PREFIX_DATA },
    /* 10 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_LEN_TABLE (VEX_LEN_0F3A14) },
    { VEX_LEN_TABLE (VEX_LEN_0F3A15) },
    { VEX_LEN_TABLE (VEX_LEN_0F3A16) },
    { VEX_LEN_TABLE (VEX_LEN_0F3A17) },
    /* 18 */
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A18) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A19) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A1A) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A1B) },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F3A1D) },
    { "vpcmpu%DQ",	{ MaskG, Vex, EXx, VPCMP }, PREFIX_DATA },
    { "vpcmp%DQ",	{ MaskG, Vex, EXx, VPCMP }, PREFIX_DATA },
    /* 20 */
    { VEX_LEN_TABLE (VEX_LEN_0F3A20) },
    { VEX_W_TABLE (EVEX_W_0F3A21) },
    { VEX_LEN_TABLE (VEX_LEN_0F3A22) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A23) },
    { Bad_Opcode },
    { "vpternlog%DQ",	{ XM, Vex, EXx, Ib }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A26) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A27) },
    /* 28 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 30 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 38 */
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A38) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A39) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A3A) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A3B) },
    { Bad_Opcode },
    { Bad_Opcode },
    { "vpcmpu%BW",	{ MaskG, Vex, EXx, VPCMP }, PREFIX_DATA },
    { "vpcmp%BW",	{ MaskG, Vex, EXx, VPCMP }, PREFIX_DATA },
    /* 40 */
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (EVEX_W_0F3A42) },
    { EVEX_LEN_TABLE (EVEX_LEN_0F3A43) },
    { "%XEvpclmulqdqY",	{ XM, Vex, EXx, PCLMUL }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 48 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 50 */
    { "vrangep%XW",	{ XM, Vex, EXx, EXxEVexS, Ib }, PREFIX_DATA },
    { "vranges%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexS, Ib }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A52) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A53) },
    { "vfixupimmp%XW",	{ XM, Vex, EXx, EXxEVexS, Ib }, PREFIX_DATA },
    { "vfixupimms%XW",	{ XMScalar, VexScalar, EXdq, EXxEVexS, Ib }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A56) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A57) },
    /* 58 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 60 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A66) },
    { PREFIX_TABLE (PREFIX_EVEX_0F3A67) },
    /* 68 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 70 */
    { VEX_W_TABLE (EVEX_W_0F3A70) },
    { "vpshld%DQ",   { XM, Vex, EXx, Ib }, PREFIX_DATA },
    { VEX_W_TABLE (EVEX_W_0F3A72) },
    { "vpshrd%DQ",   { XM, Vex, EXx, Ib }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { X86_64_TABLE (X86_64_EVEX_0F3A77) },
    /* 78 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 80 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 90 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 98 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_0F3AC2) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { VEX_W_TABLE (VEX_W_0F3ACE) },
    { VEX_W_TABLE (VEX_W_0F3ACF) },
    /* D0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F0 */
    { X86_64_EVEX_PFX_TABLE (PREFIX_VEX_0F3AF0_L_0) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
  },
  /* EVEX_MAP4_ */
  {
    /* 00 */
    { "%NFaddB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "%NFaddS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NFaddB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "%NFaddS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 08 */
    { "%NForB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "%NForS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NForB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "%NForS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 10 */
    { "adcB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "adcS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "adcB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "adcS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 18 */
    { "sbbB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "sbbS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "sbbB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "sbbS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 20 */
    { "%NFandB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "%NFandS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NFandB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "%NFandS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { "%NFshldS",	{ VexGv, Ev, Gv, Ib }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 28 */
    { "%NFsubB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "%NFsubS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NFsubB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "%NFsubS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { "%NFshrdS",	{ VexGv, Ev, Gv, Ib }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 30 */
    { "%NFxorB",	{ VexGb, Eb, Gb }, NO_PREFIX },
    { "%NFxorS",	{ VexGv, Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NFxorB",	{ VexGb, Gb, EbS }, NO_PREFIX },
    { "%NFxorS",	{ VexGv, Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 38 */
    { "%NEccmp%SCB%DF",	{ Eb, Gb }, 0 },
    { "%NEccmp%SCS%DF",	{ Ev, Gv }, PREFIX_NP_OR_DATA },
    { "%NEccmp%SCB%DF",	{ Gb, EbS }, 0 },
    { "%NEccmp%SCS%DF",	{ Gv, EvS }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 40 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    /* 48 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_4x) },
    /* 50 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 58 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 60 */
    { MOD_TABLE (MOD_EVEX_MAP4_60) },
    { MOD_TABLE (MOD_EVEX_MAP4_61) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "wrussK",	{ M, Gdq }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_0F38F6) },
    { Bad_Opcode },
    /* 68 */
    { Bad_Opcode },
    { "%NFimul%ZUS",	{ Gv, Ev, Iv }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { "%NFimul%ZUS",	{ Gv, Ev, sIb }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 70 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 78 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 80 */
    { REG_TABLE (REG_EVEX_MAP4_80) },
    { REG_TABLE (REG_EVEX_MAP4_81) },
    { Bad_Opcode },
    { REG_TABLE (REG_EVEX_MAP4_83) },
    { "%NEctest%SCB%DF",	      { Eb, Gb }, NO_PREFIX },
    { "%NEctest%SCS%DF",	      { Ev, Gv }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { "%NFpopcntS",	{ Gv, Ev }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { "movrsB",	{ Gb, Mb }, NO_PREFIX },
    { "movrsS",	{ Gv, Mv }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { REG_TABLE (REG_EVEX_MAP4_8F) },
    /* 90 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 98 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%NFshldS",	{ VexGv, Ev, Gv, CL }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "%NFshrdS",	{ VexGv, Ev, Gv, CL }, PREFIX_NP_OR_DATA },
    { Bad_Opcode },
    { "%NFimulS",	{ VexGv, Gv, Ev }, PREFIX_NP_OR_DATA },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C0 */
    { REG_TABLE (REG_C0) },
    { REG_TABLE (REG_C1) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D0 */
    { REG_TABLE (REG_D0) },
    { REG_TABLE (REG_D1) },
    { REG_TABLE (REG_D2) },
    { REG_TABLE (REG_D3) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F0 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_F0) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_F1) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_F2) },
    { Bad_Opcode },
    { "%NFtzcntS",	{ Gv, Ev }, PREFIX_NP_OR_DATA },
    { "%NFlzcntS",	{ Gv, Ev }, PREFIX_NP_OR_DATA },
    { REG_TABLE (REG_EVEX_MAP4_F6) },
    { REG_TABLE (REG_EVEX_MAP4_F7) },
    /* F8 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP4_F8) },
    { "movdiri",	{ Mdq, Gdq }, NO_PREFIX },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_0F38FC) },
    { Bad_Opcode },
    { REG_TABLE (REG_EVEX_MAP4_FE) },
    { REG_TABLE (REG_EVEX_MAP4_FF) },
  },
  /* EVEX_MAP5_ */
  {
    /* 00 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 08 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 10 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_10) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_11) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 18 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_18) },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_1B) },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_1D) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_1E) },
    { Bad_Opcode },
    /* 20 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 28 */
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_2A) },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_2C) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_2D) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_2E) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_2F) },
    /* 30 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 38 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 40 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 48 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 50 */
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_51) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 58 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_58) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_59) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5A) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5B) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5C) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5D) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5E) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_5F) },
    /* 60 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 68 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_68) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_69) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_6A) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_6B) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_6C) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_6D) },
    { EVEX_LEN_TABLE (EVEX_LEN_MAP5_6E) },
    { X86_64_TABLE (X86_64_EVEX_MAP5_6F) },
    /* 70 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_74) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 78 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_78) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_79) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_7A) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_7B) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_7C) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP5_7D) },
    { EVEX_LEN_TABLE (EVEX_LEN_MAP5_7E) },
    { Bad_Opcode },
    /* 80 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 90 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 98 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* A8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* B8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F8 */
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_MAP5_F8) },
    { X86_64_EVEX_FROM_VEX_TABLE (X86_64_VEX_MAP5_F9) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
  },
  /* EVEX_MAP6_ */
  {
    /* 00 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 08 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 10 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_13) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 18 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 20 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 28 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_2C) },
    { "vscalefs%XH",      { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 30 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 38 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 40 */
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_42) },
    { "vgetexps%XH",      { XMScalar, VexScalar, EXw, EXxEVexS }, PREFIX_DATA },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 48 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_4C) },
    { "vrcps%XH",	  { XMScalar, VexScalar, EXw }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_4E) },
    { "vrsqrts%XH",       { XMScalar, VexScalar, EXw }, PREFIX_DATA },
    /* 50 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_56) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_57) },
    /* 58 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 60 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 68 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 70 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 78 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 80 */
    { VEX_W_TABLE (EVEX_W_MAP6_80) },
    { VEX_W_TABLE (EVEX_W_MAP6_81) },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 88 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* 90 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "vfmaddsub132p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    { "vfmsubadd132p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    /* 98 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_98) },
    { "vfmadd132s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_9A) },
    { "vfmsub132s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_9C) },
    { "vfnmadd132s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_9E) },
    { "vfnmsub132s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    /* A0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "vfmaddsub213p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    { "vfmsubadd213p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    /* A8 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_A8) },
    { "vfmadd213s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_AA) },
    { "vfmsub213s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_AC) },
    { "vfnmadd213s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_AE) },
    { "vfnmsub213s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    /* B0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { "vfmaddsub231p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    { "vfmsubadd231p%XH",  { XM, Vex, EXxh, EXxEVexR }, PREFIX_DATA },
    /* B8 */
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_B8) },
    { "vfmadd231s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_BA) },
    { "vfmsub231s%XH",  { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_BC) },
    { "vfnmadd231s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_BE) },
    { "vfnmsub231s%XH", { XMScalar, VexScalar, EXw, EXxEVexR }, PREFIX_DATA },
    /* C0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* C8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* D0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_D6) },
    { PREFIX_TABLE (PREFIX_EVEX_MAP6_D7) },
    /* D8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* E8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F0 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    /* F8 */
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
    { Bad_Opcode },
  },
};
