/*
 * Copyright (c) 2007, 2008, 2009, Czirkos Zoltan <cirix@fw.hu>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef BD_ELEMENTS_H
#define BD_ELEMENTS_H


// These are the "objects" (cells) in caves.
//
// Many of them have a "scanned" pair, which is required by the engine.

typedef enum _element
{
  O_SPACE,
  O_DIRT,
  O_DIRT_CRUMBLED,
  O_DIRT_DIGGING_LEFT,
  O_DIRT_DIGGING_RIGHT,
  O_DIRT_DIGGING_UP,
  O_DIRT_DIGGING_DOWN,
  O_DIRT_DIGGING_LEFT_CRUMBLED,
  O_DIRT_DIGGING_RIGHT_CRUMBLED,
  O_DIRT_DIGGING_UP_CRUMBLED,
  O_DIRT_DIGGING_DOWN_CRUMBLED,
  O_DIRT_SLOPED_UP_RIGHT,
  O_DIRT_SLOPED_UP_LEFT,
  O_DIRT_SLOPED_DOWN_LEFT,
  O_DIRT_SLOPED_DOWN_RIGHT,
  O_DIRT_SLOPED_UP_RIGHT_CRUMBLED,
  O_DIRT_SLOPED_UP_LEFT_CRUMBLED,
  O_DIRT_SLOPED_DOWN_LEFT_CRUMBLED,
  O_DIRT_SLOPED_DOWN_RIGHT_CRUMBLED,
  O_DIRT_BALL,
  O_DIRT_BALL_scanned,
  O_DIRT_BALL_F,
  O_DIRT_BALL_F_scanned,
  O_DIRT_LOOSE,
  O_DIRT_LOOSE_scanned,
  O_DIRT_LOOSE_F,
  O_DIRT_LOOSE_F_scanned,
  O_DIRT2,
  O_DIRT2_CRUMBLED,
  O_DIRT2_DIGGING_LEFT,
  O_DIRT2_DIGGING_RIGHT,
  O_DIRT2_DIGGING_UP,
  O_DIRT2_DIGGING_DOWN,
  O_DIRT2_DIGGING_LEFT_CRUMBLED,
  O_DIRT2_DIGGING_RIGHT_CRUMBLED,
  O_DIRT2_DIGGING_UP_CRUMBLED,
  O_DIRT2_DIGGING_DOWN_CRUMBLED,
  O_BRICK,
  O_BRICK_SLOPED_UP_RIGHT,
  O_BRICK_SLOPED_UP_LEFT,
  O_BRICK_SLOPED_DOWN_LEFT,
  O_BRICK_SLOPED_DOWN_RIGHT,
  O_BRICK_NON_SLOPED,
  O_MAGIC_WALL,
  O_PRE_OUTBOX,
  O_OUTBOX,
  O_PRE_INVIS_OUTBOX,
  O_INVIS_OUTBOX,
  O_PRE_STEEL_OUTBOX,
  O_STEEL_OUTBOX,
  O_PRE_INVIS_STEEL_OUTBOX,
  O_INVIS_STEEL_OUTBOX,
  O_STEEL,
  O_STEEL_SLOPED_UP_RIGHT,
  O_STEEL_SLOPED_UP_LEFT,
  O_STEEL_SLOPED_DOWN_LEFT,
  O_STEEL_SLOPED_DOWN_RIGHT,
  O_STEEL_EXPLODABLE,
  O_STEEL_EATABLE,
  O_BRICK_EATABLE,

  O_STONE,
  O_STONE_scanned,
  O_STONE_F,
  O_STONE_F_scanned,
  O_FLYING_STONE,
  O_FLYING_STONE_scanned,
  O_FLYING_STONE_F,
  O_FLYING_STONE_F_scanned,
  O_MEGA_STONE,
  O_MEGA_STONE_scanned,
  O_MEGA_STONE_F,
  O_MEGA_STONE_F_scanned,
  O_LIGHT_STONE,
  O_LIGHT_STONE_scanned,
  O_LIGHT_STONE_F,
  O_LIGHT_STONE_F_scanned,
  O_DIAMOND,
  O_DIAMOND_scanned,
  O_DIAMOND_F,
  O_DIAMOND_F_scanned,
  O_FLYING_DIAMOND,
  O_FLYING_DIAMOND_scanned,
  O_FLYING_DIAMOND_F,
  O_FLYING_DIAMOND_F_scanned,
  O_NUT,
  O_NUT_scanned,
  O_NUT_F,
  O_NUT_F_scanned,

  O_BLADDER_SPENDER,
  O_INBOX,

  O_H_EXPANDING_WALL,
  O_H_EXPANDING_WALL_scanned,
  O_V_EXPANDING_WALL,
  O_V_EXPANDING_WALL_scanned,
  O_EXPANDING_WALL,
  O_EXPANDING_WALL_scanned,
  O_H_EXPANDING_STEEL_WALL,
  O_H_EXPANDING_STEEL_WALL_scanned,
  O_V_EXPANDING_STEEL_WALL,
  O_V_EXPANDING_STEEL_WALL_scanned,
  O_EXPANDING_STEEL_WALL,
  O_EXPANDING_STEEL_WALL_scanned,

  O_EXPANDING_WALL_SWITCH,
  O_CREATURE_SWITCH,
  O_BITER_SWITCH,
  O_REPLICATOR_SWITCH,
  O_CONVEYOR_SWITCH,
  O_CONVEYOR_DIR_SWITCH,

  O_ACID,
  O_ACID_scanned,
  O_FALLING_WALL,
  O_FALLING_WALL_F,
  O_FALLING_WALL_F_scanned,

  O_BOX,
  O_TIME_PENALTY,
  O_GRAVESTONE,
  O_STONE_GLUED,
  O_DIAMOND_GLUED,
  O_DIAMOND_KEY,
  O_TRAPPED_DIAMOND,
  O_CLOCK,
  O_DIRT_GLUED,
  O_DIRT_GLUED_CRUMBLED,
  O_KEY_1,
  O_KEY_2,
  O_KEY_3,
  O_DOOR_1,
  O_DOOR_2,
  O_DOOR_3,

  O_POT,
  O_GRAVITY_SWITCH,
  O_PNEUMATIC_HAMMER,
  O_TELEPORTER,
  O_SKELETON,
  O_WATER,
  O_WATER_1,
  O_WATER_2,
  O_WATER_3,
  O_WATER_4,
  O_WATER_5,
  O_WATER_6,
  O_WATER_7,
  O_WATER_8,
  O_WATER_9,
  O_WATER_10,
  O_WATER_11,
  O_WATER_12,
  O_WATER_13,
  O_WATER_14,
  O_WATER_15,
  O_WATER_16,
  O_COW,
  O_COW_1,
  O_COW_2,
  O_COW_3,
  O_COW_4,
  O_COW_1_scanned,
  O_COW_2_scanned,
  O_COW_3_scanned,
  O_COW_4_scanned,
  O_COW_ENCLOSED_1,
  O_COW_ENCLOSED_2,
  O_COW_ENCLOSED_3,
  O_COW_ENCLOSED_4,
  O_COW_ENCLOSED_5,
  O_COW_ENCLOSED_6,
  O_COW_ENCLOSED_7,
  O_WALLED_DIAMOND,
  O_WALLED_KEY_1,
  O_WALLED_KEY_2,
  O_WALLED_KEY_3,

  O_AMOEBA,
  O_AMOEBA_scanned,
  O_AMOEBA_2,
  O_AMOEBA_2_scanned,
  O_REPLICATOR,
  O_CONVEYOR_LEFT,
  O_CONVEYOR_RIGHT,
  O_LAVA,
  O_SWEET,
  O_VOODOO,
  O_SLIME,
  O_BLADDER,
  O_BLADDER_1,
  O_BLADDER_2,
  O_BLADDER_3,
  O_BLADDER_4,
  O_BLADDER_5,
  O_BLADDER_6,
  O_BLADDER_7,
  O_BLADDER_8,

  O_WAITING_STONE,
  O_WAITING_STONE_scanned,
  O_CHASING_STONE,
  O_CHASING_STONE_scanned,
  O_GHOST,
  O_GHOST_scanned,
  O_FIREFLY,
  O_FIREFLY_1,
  O_FIREFLY_2,
  O_FIREFLY_3,
  O_FIREFLY_4,
  O_FIREFLY_1_scanned,
  O_FIREFLY_2_scanned,
  O_FIREFLY_3_scanned,
  O_FIREFLY_4_scanned,
  O_ALT_FIREFLY,
  O_ALT_FIREFLY_1,
  O_ALT_FIREFLY_2,
  O_ALT_FIREFLY_3,
  O_ALT_FIREFLY_4,
  O_ALT_FIREFLY_1_scanned,
  O_ALT_FIREFLY_2_scanned,
  O_ALT_FIREFLY_3_scanned,
  O_ALT_FIREFLY_4_scanned,
  O_BUTTER,
  O_BUTTER_1,
  O_BUTTER_2,
  O_BUTTER_3,
  O_BUTTER_4,
  O_BUTTER_1_scanned,
  O_BUTTER_2_scanned,
  O_BUTTER_3_scanned,
  O_BUTTER_4_scanned,
  O_ALT_BUTTER,
  O_ALT_BUTTER_1,
  O_ALT_BUTTER_2,
  O_ALT_BUTTER_3,
  O_ALT_BUTTER_4,
  O_ALT_BUTTER_1_scanned,
  O_ALT_BUTTER_2_scanned,
  O_ALT_BUTTER_3_scanned,
  O_ALT_BUTTER_4_scanned,
  O_STONEFLY,
  O_STONEFLY_1,
  O_STONEFLY_2,
  O_STONEFLY_3,
  O_STONEFLY_4,
  O_STONEFLY_1_scanned,
  O_STONEFLY_2_scanned,
  O_STONEFLY_3_scanned,
  O_STONEFLY_4_scanned,
  O_BITER,
  O_BITER_1,
  O_BITER_2,
  O_BITER_3,
  O_BITER_4,
  O_BITER_1_scanned,
  O_BITER_2_scanned,
  O_BITER_3_scanned,
  O_BITER_4_scanned,
  O_DRAGONFLY,
  O_DRAGONFLY_1,
  O_DRAGONFLY_2,
  O_DRAGONFLY_3,
  O_DRAGONFLY_4,
  O_DRAGONFLY_1_scanned,
  O_DRAGONFLY_2_scanned,
  O_DRAGONFLY_3_scanned,
  O_DRAGONFLY_4_scanned,

  O_PRE_PL_1,
  O_PRE_PL_2,
  O_PRE_PL_3,
  O_PLAYER_START,
  O_PLAYER_START_scanned,
  O_PLAYER,
  O_PLAYER_scanned,
  O_PLAYER_BOMB,
  O_PLAYER_BOMB_scanned,
  O_PLAYER_ROCKET_LAUNCHER,
  O_PLAYER_ROCKET_LAUNCHER_scanned,
  O_PLAYER_GLUED,
  O_PLAYER_STIRRING,

  O_ROCKET_LAUNCHER,
  O_ROCKET,
  O_ROCKET_1,
  O_ROCKET_1_scanned,
  O_ROCKET_2,
  O_ROCKET_2_scanned,
  O_ROCKET_3,
  O_ROCKET_3_scanned,
  O_ROCKET_4,
  O_ROCKET_4_scanned,

  O_BOMB,
  O_BOMB_TICK_1,
  O_BOMB_TICK_2,
  O_BOMB_TICK_3,
  O_BOMB_TICK_4,
  O_BOMB_TICK_5,
  O_BOMB_TICK_6,
  O_BOMB_TICK_7,

  O_NITRO_PACK,
  O_NITRO_PACK_scanned,
  O_NITRO_PACK_F,
  O_NITRO_PACK_F_scanned,
  O_NITRO_PACK_EXPLODE,
  O_NITRO_PACK_EXPLODE_scanned,

  O_PRE_CLOCK_0,
  O_PRE_CLOCK_1,
  O_PRE_CLOCK_2,
  O_PRE_CLOCK_3,
  O_PRE_CLOCK_4,
  O_PRE_DIA_0,
  O_PRE_DIA_1,
  O_PRE_DIA_2,
  O_PRE_DIA_3,
  O_PRE_DIA_4,
  O_PRE_DIA_5,
  O_EXPLODE_0,
  O_EXPLODE_1,
  O_EXPLODE_2,
  O_EXPLODE_3,
  O_EXPLODE_4,
  O_EXPLODE_5,
  O_PRE_STONE_0,
  O_PRE_STONE_1,
  O_PRE_STONE_2,
  O_PRE_STONE_3,
  O_PRE_STONE_4,
  O_PRE_STEEL_0,
  O_PRE_STEEL_1,
  O_PRE_STEEL_2,
  O_PRE_STEEL_3,
  O_PRE_STEEL_4,
  O_GHOST_EXPL_0,
  O_GHOST_EXPL_1,
  O_GHOST_EXPL_2,
  O_GHOST_EXPL_3,
  O_GHOST_EXPL_4,
  O_BOMB_EXPL_0,
  O_BOMB_EXPL_1,
  O_BOMB_EXPL_2,
  O_BOMB_EXPL_3,
  O_BOMB_EXPL_4,
  O_NITRO_EXPL_0,
  O_NITRO_EXPL_1,
  O_NITRO_EXPL_2,
  O_NITRO_EXPL_3,
  O_NITRO_EXPL_4,
  O_AMOEBA_2_EXPL_0,
  O_AMOEBA_2_EXPL_1,
  O_AMOEBA_2_EXPL_2,
  O_AMOEBA_2_EXPL_3,
  O_AMOEBA_2_EXPL_4,
  O_NUT_CRACK_0,
  O_NUT_CRACK_1,
  O_NUT_CRACK_2,
  O_NUT_CRACK_3,
  O_NUT_CRACK_4,

  // these are used internally for the pneumatic hammer, and should not be used in the editor!
  // (not even as an effect destination or something like that)
  O_PLAYER_PNEUMATIC_LEFT,
  O_PLAYER_PNEUMATIC_RIGHT,
  O_PNEUMATIC_ACTIVE_LEFT,
  O_PNEUMATIC_ACTIVE_RIGHT,

  O_UNKNOWN,	// unknown element imported or read from bdcff
  O_NONE,	// do not draw this element when creating cave; can be used,
	        // for example, to skip drawing a maze's path

  O_MAX,	// remembering last index: this should get an integer value
		// which is 1 more than the one above.

  // fake elements to help drawing
  O_FAKE_BONUS,
  O_INBOX_CLOSED,
  O_INBOX_OPEN,
  O_OUTBOX_CLOSED,
  O_OUTBOX_OPEN,
  O_STEEL_OUTBOX_CLOSED,
  O_STEEL_OUTBOX_OPEN,
  O_COVERED,
  O_PLAYER_LEFT,
  O_PLAYER_RIGHT,
  O_PLAYER_UP,
  O_PLAYER_DOWN,
  O_PLAYER_TAP,
  O_PLAYER_BLINK,
  O_PLAYER_TAP_BLINK,
  O_PLAYER_PUSH_LEFT,
  O_PLAYER_PUSH_RIGHT,
  O_PLAYER_BOMB_TURNING,
  O_PLAYER_ROCKET_LAUNCHER_TURNING,
  O_CREATURE_SWITCH_ON,
  O_EXPANDING_WALL_SWITCH_HORIZ,
  O_EXPANDING_WALL_SWITCH_VERT,
  O_GRAVITY_SWITCH_ACTIVE,
  O_REPLICATOR_SWITCH_ON,
  O_REPLICATOR_SWITCH_OFF,
  O_CONVEYOR_DIR_NORMAL,
  O_CONVEYOR_DIR_CHANGED,
  O_CONVEYOR_SWITCH_OFF,
  O_CONVEYOR_SWITCH_ON,

  O_MAGIC_WALL_ACTIVE,
  O_REPLICATOR_ACTIVE,
  O_CONVEYOR_LEFT_ACTIVE,
  O_CONVEYOR_RIGHT_ACTIVE,
  O_BITER_SWITCH_1,
  O_BITER_SWITCH_2,
  O_BITER_SWITCH_3,
  O_BITER_SWITCH_4,
  O_BITER_SWITCH_1_CRUMBLED,
  O_BITER_SWITCH_2_CRUMBLED,
  O_BITER_SWITCH_3_CRUMBLED,
  O_BITER_SWITCH_4_CRUMBLED,

  O_STONE_MOVE_LEFT,
  O_STONE_MOVE_RIGHT,
  O_STONE_PUSH_LEFT,
  O_STONE_PUSH_RIGHT,

  O_QUESTION_MARK,
  O_EATABLE,
  O_DOWN_ARROW,
  O_LEFTRIGHT_ARROW,
  O_EVERYDIR_ARROW,
  O_GLUED,
  O_OUT,
  O_EXCLAMATION_MARK,

  O_MAX_ALL
} GdElement;

typedef enum _sound
{
  GD_S_NONE,

  GD_S_STONE_PUSHING,
  GD_S_STONE_FALLING,
  GD_S_STONE_IMPACT_RANDOM,		// randomly select a stone impact sound
  GD_S_STONE_IMPACT_1,
  GD_S_STONE_IMPACT_2,
  GD_S_STONE_IMPACT_3,
  GD_S_STONE_IMPACT_4,
  GD_S_STONE_IMPACT_5,
  GD_S_STONE_IMPACT_6,
  GD_S_STONE_IMPACT_7,
  GD_S_STONE_IMPACT_8,
  GD_S_MEGA_STONE_PUSHING,
  GD_S_MEGA_STONE_FALLING,
  GD_S_MEGA_STONE_IMPACT_RANDOM,	// randomly select a mega stone impact sound
  GD_S_MEGA_STONE_IMPACT_1,
  GD_S_MEGA_STONE_IMPACT_2,
  GD_S_MEGA_STONE_IMPACT_3,
  GD_S_MEGA_STONE_IMPACT_4,
  GD_S_MEGA_STONE_IMPACT_5,
  GD_S_MEGA_STONE_IMPACT_6,
  GD_S_MEGA_STONE_IMPACT_7,
  GD_S_MEGA_STONE_IMPACT_8,
  GD_S_LIGHT_STONE_PUSHING,
  GD_S_LIGHT_STONE_FALLING,
  GD_S_LIGHT_STONE_IMPACT_RANDOM,	// randomly select a light stone impact sound
  GD_S_LIGHT_STONE_IMPACT_1,
  GD_S_LIGHT_STONE_IMPACT_2,
  GD_S_LIGHT_STONE_IMPACT_3,
  GD_S_LIGHT_STONE_IMPACT_4,
  GD_S_LIGHT_STONE_IMPACT_5,
  GD_S_LIGHT_STONE_IMPACT_6,
  GD_S_LIGHT_STONE_IMPACT_7,
  GD_S_LIGHT_STONE_IMPACT_8,
  GD_S_FLYING_STONE_PUSHING,
  GD_S_FLYING_STONE_FALLING,
  GD_S_FLYING_STONE_IMPACT,
  GD_S_WAITING_STONE_PUSHING,
  GD_S_CHASING_STONE_PUSHING,
  GD_S_NUT_PUSHING,
  GD_S_NUT_FALLING,
  GD_S_NUT_IMPACT,
  GD_S_NUT_CRACKING,
  GD_S_DIRT_BALL_FALLING,
  GD_S_DIRT_BALL_IMPACT,
  GD_S_DIRT_LOOSE_FALLING,
  GD_S_DIRT_LOOSE_IMPACT,
  GD_S_NITRO_PACK_PUSHING,
  GD_S_NITRO_PACK_FALLING,
  GD_S_NITRO_PACK_IMPACT,
  GD_S_FALLING_WALL_FALLING,
  GD_S_FALLING_WALL_IMPACT,
  GD_S_EXPANDING_WALL,
  GD_S_WALL_REAPPEARING,
  GD_S_DIAMOND_FALLING_RANDOM,		// randomly select a diamond falling sound
  GD_S_DIAMOND_FALLING_1,
  GD_S_DIAMOND_FALLING_2,
  GD_S_DIAMOND_FALLING_3,
  GD_S_DIAMOND_FALLING_4,
  GD_S_DIAMOND_FALLING_5,
  GD_S_DIAMOND_FALLING_6,
  GD_S_DIAMOND_FALLING_7,
  GD_S_DIAMOND_FALLING_8,
  GD_S_DIAMOND_IMPACT_RANDOM,		// randomly select a diamond impact sound
  GD_S_DIAMOND_IMPACT_1,
  GD_S_DIAMOND_IMPACT_2,
  GD_S_DIAMOND_IMPACT_3,
  GD_S_DIAMOND_IMPACT_4,
  GD_S_DIAMOND_IMPACT_5,
  GD_S_DIAMOND_IMPACT_6,
  GD_S_DIAMOND_IMPACT_7,
  GD_S_DIAMOND_IMPACT_8,
  GD_S_FLYING_DIAMOND_FALLING_RANDOM,	// randomly select a flying diamond falling sound
  GD_S_FLYING_DIAMOND_FALLING_1,
  GD_S_FLYING_DIAMOND_FALLING_2,
  GD_S_FLYING_DIAMOND_FALLING_3,
  GD_S_FLYING_DIAMOND_FALLING_4,
  GD_S_FLYING_DIAMOND_FALLING_5,
  GD_S_FLYING_DIAMOND_FALLING_6,
  GD_S_FLYING_DIAMOND_FALLING_7,
  GD_S_FLYING_DIAMOND_FALLING_8,
  GD_S_FLYING_DIAMOND_IMPACT_RANDOM,	// randomly select a flying diamond impact sound
  GD_S_FLYING_DIAMOND_IMPACT_1,
  GD_S_FLYING_DIAMOND_IMPACT_2,
  GD_S_FLYING_DIAMOND_IMPACT_3,
  GD_S_FLYING_DIAMOND_IMPACT_4,
  GD_S_FLYING_DIAMOND_IMPACT_5,
  GD_S_FLYING_DIAMOND_IMPACT_6,
  GD_S_FLYING_DIAMOND_IMPACT_7,
  GD_S_FLYING_DIAMOND_IMPACT_8,
  GD_S_DIAMOND_COLLECTING,
  GD_S_FLYING_DIAMOND_COLLECTING,
  GD_S_SKELETON_COLLECTING,
  GD_S_PNEUMATIC_COLLECTING,
  GD_S_BOMB_COLLECTING,
  GD_S_CLOCK_COLLECTING,
  GD_S_SWEET_COLLECTING,
  GD_S_KEY_COLLECTING,
  GD_S_DIAMOND_KEY_COLLECTING,
  GD_S_SLIME,
  GD_S_LAVA,
  GD_S_REPLICATOR,
  GD_S_ACID_SPREADING,
  GD_S_BLADDER_MOVING,
  GD_S_BLADDER_PUSHING,
  GD_S_BLADDER_CONVERTING,
  GD_S_BLADDER_SPENDER,
  GD_S_BITER_EATING,
  GD_S_DYING,

  GD_S_DOOR_OPENING,
  GD_S_DIRT_WALKING_RANDOM,		// randomly select a dirt walking sound
  GD_S_DIRT_WALKING_1,
  GD_S_DIRT_WALKING_2,
  GD_S_DIRT_WALKING_3,
  GD_S_DIRT_WALKING_4,
  GD_S_DIRT_WALKING_5,
  GD_S_DIRT_WALKING_6,
  GD_S_DIRT_WALKING_7,
  GD_S_DIRT_WALKING_8,
  GD_S_EMPTY_WALKING_RANDOM,		// randomly select an empty space walking sound
  GD_S_EMPTY_WALKING_1,
  GD_S_EMPTY_WALKING_2,
  GD_S_EMPTY_WALKING_3,
  GD_S_EMPTY_WALKING_4,
  GD_S_EMPTY_WALKING_5,
  GD_S_EMPTY_WALKING_6,
  GD_S_EMPTY_WALKING_7,
  GD_S_EMPTY_WALKING_8,
  GD_S_STIRRING,
  GD_S_BOX_PUSHING,
  GD_S_TELEPORTER,
  GD_S_TIMEOUT_10,
  GD_S_TIMEOUT_9,
  GD_S_TIMEOUT_8,
  GD_S_TIMEOUT_7,
  GD_S_TIMEOUT_6,
  GD_S_TIMEOUT_5,
  GD_S_TIMEOUT_4,
  GD_S_TIMEOUT_3,
  GD_S_TIMEOUT_2,
  GD_S_TIMEOUT_1,
  GD_S_TIMEOUT_0,
  GD_S_EXPLODING,
  GD_S_BOMB_EXPLODING,
  GD_S_GHOST_EXPLODING,
  GD_S_VOODOO_EXPLODING,
  GD_S_NITRO_PACK_EXPLODING,
  GD_S_BOMB_PLACING,
  GD_S_FINISHED,		// loop
  GD_S_SWITCH_BITER,
  GD_S_SWITCH_CREATURES,
  GD_S_SWITCH_GRAVITY,
  GD_S_SWITCH_EXPANDING,
  GD_S_SWITCH_CONVEYOR,
  GD_S_SWITCH_REPLICATOR,
  GD_S_AMOEBA_GROWING,
  GD_S_AMOEBA_2_GROWING,

  GD_S_AMOEBA,			// loop
  GD_S_AMOEBA_2,		// loop
  GD_S_AMOEBA_MAGIC,		// loop
  GD_S_AMOEBA_2_MAGIC,		// loop
  GD_S_MAGIC_WALL,		// loop
  GD_S_COVERING,		// loop
  GD_S_PNEUMATIC_HAMMER,	// loop
  GD_S_WATER,			// loop
  GD_S_COW,			// loop
  GD_S_BITER,			// loop
  GD_S_FIREFLY,			// loop
  GD_S_ALT_FIREFLY,		// loop
  GD_S_BUTTER,			// loop
  GD_S_ALT_BUTTER,		// loop
  GD_S_STONEFLY,		// loop
  GD_S_DRAGONFLY,		// loop

  GD_S_CRACKING,
  GD_S_GRAVITY_CHANGING,
  GD_S_BONUS_LIFE,

  GD_S_MAX,
} GdSound;

#endif	// BD_ELEMENTS_H
